/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import com.jrockit.mc.flightrecorder.spi.ITrackView;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.TrackSampler;
import java.awt.Color;
import java.util.Iterator;

public class UILevelInstance
implements Visitable,
Comparable {
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final IRange m_range = IRange.INFINITE_RANGE;
    private final ITrackView m_trackview;
    private final String m_name;

    public UILevelInstance(ITrackView view, String name, Color color) {
        this.m_trackview = view;
        this.m_name = name;
        TrackSampler sampler = new TrackSampler();
        this.m_renderInfo.setSampler(sampler);
        this.m_renderInfo.setColor(this.createGreenShadedColor(color));
        sampler.setInput(this.m_trackview);
    }

    public MCColor createGreenShadedColor(Color color) {
        float[] greenHSB = Color.RGBtoHSB(0, 255, 0, null);
        Color newColor = new Color(Color.HSBtoRGB(greenHSB[0], 0.3f + 0.3f * ((float)color.getGreen() / 255.0f), 0.5f + 0.5f * ((float)color.getBlue() / 255.0f)));
        return new MCColor(newColor);
    }

    public String toString() {
        return this.m_name;
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public MCColor getColor() {
        return new MCColor(Color.ORANGE);
    }

    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    public int compareTo(Object arg0) {
        UILevelInstance uthat = (UILevelInstance)arg0;
        return uthat.getName().compareTo(this.getName());
    }

    public IRange getRange() {
        return this.m_range;
    }

    public String getName() {
        return this.m_name;
    }

    public Iterator iterator() {
        this.m_trackview.setRange(IRange.INFINITE_RANGE);
        this.m_trackview.setFilter((IRangeFilter)IRangeHolder.ALWAYS_TRUE_FILTER);
        this.m_trackview.setExpansion(RangeSelection.NORMAL);
        return this.m_trackview.iterator();
    }

    public Iterator iterator(IRangeFilter filter, IRange range, RangeSelection rs) {
        this.m_trackview.setRange(range);
        this.m_trackview.setFilter(filter);
        this.m_trackview.setExpansion(rs);
        return this.m_trackview.iterator();
    }
}

