/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ColorFunction;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class UIGarbageCollector
implements Visitable {
    private final RenderInfo m_evenRenderInfo = new RenderInfo();
    private final RenderInfo m_oddRenderInfo = new RenderInfo();
    private final CompositeRangeSampler m_sampler;
    private final ArrayList m_levelInstances = new ArrayList(10);

    public UIGarbageCollector() {
        this.m_sampler = new CompositeRangeSampler();
        this.getOddRenderInfo().setSampler(this.m_sampler);
        ColorFunction f = new ColorFunction(GraphHelper.GC_ODD_COLOR, GraphHelper.ODD_COLOR);
        this.getOddRenderInfo().setColorFunction(f);
        this.getEvenRenderInfo().setSampler(this.m_sampler);
        ColorFunction f2 = new ColorFunction(GraphHelper.GC_EVEN_COLOR, GraphHelper.EVEN_COLOR);
        this.getEvenRenderInfo().setColorFunction(f2);
    }

    public CompositeRangeSampler getSampler() {
        return this.m_sampler;
    }

    public void addLevelInstances(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addLevelInstance((UILevelInstance)it.next());
        }
    }

    public void addLevelInstance(UILevelInstance uiLevelInstance) {
        this.m_levelInstances.add(uiLevelInstance);
        this.m_sampler.add(uiLevelInstance.getRenderInfo().getSampleComponent());
        Collections.sort(this.m_levelInstances);
    }

    public RenderInfo getOddRenderInfo() {
        return this.m_oddRenderInfo;
    }

    public RenderInfo getEvenRenderInfo() {
        return this.m_evenRenderInfo;
    }

    public Collection getLevelInstances() {
        return this.m_levelInstances;
    }

    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    public String getName() {
        return "Gc";
    }

    public String toString() {
        return this.getName();
    }
}

