/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIProducer;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;

public class UIEventType
implements Comparable {
    private final IEventType m_eventType;
    private final MCColor m_color;
    private boolean m_visible = true;
    private UIProducer m_uiProducer;
    private UIModel m_uiModel;

    public UIEventType(UIModel model, IEventType eventType, UIProducer uiProducer) {
        this.m_eventType = eventType;
        this.m_uiModel = model;
        this.m_uiProducer = uiProducer;
        this.m_color = new MCColor(eventType.getColor());
    }

    public UIProducer getProducer() {
        return this.m_uiProducer;
    }

    public String getName() {
        return this.m_eventType.getName();
    }

    public UIModel getModel() {
        return this.m_uiModel;
    }

    public boolean isVisible() {
        return EventToolkit.isVisible(this.m_eventType);
    }

    public void setVisible(boolean visible) {
        EventToolkit.setVisible(this.m_eventType, visible);
    }

    public boolean getVisible() {
        return this.m_visible;
    }

    public MCColor getColor() {
        return this.m_color;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof UIEventType) {
            return this.getName().compareTo(((UIEventType)arg0).getName());
        }
        return 0;
    }

    public String getDescription() {
        return this.m_eventType.getDescription();
    }

    public int getEventCount() {
        return this.getEventType().getEventCount();
    }

    public IEventType getEventType() {
        return this.m_eventType;
    }
}

