/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class UIComponents {
    public static final String UI_COMPONENTS_SETTINGS = "latency.ui.components";
    private ArrayList m_threadGroups = new ArrayList();
    private Collection m_threads = new ArrayList();
    private Collection m_eventTypes = new ArrayList();
    private Collection m_LevelTypes = new ArrayList();
    private TreeSet m_producer = new TreeSet();
    private UIGarbageCollector m_garbageCollector = new UIGarbageCollector();
    private ArrayList m_listeners = new ArrayList(5);
    private Collection m_uiEventValueTypes = new ArrayList(50);
    private int m_count;

    public int getEventsCount() {
        return this.m_count;
    }

    public void setCount(int count) {
        this.m_count = count;
    }

    public void addListener(UIComponentChange listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(UIComponentChange listener) {
        this.m_listeners.remove(listener);
    }

    public void markComponentsDirty(boolean structural) {
        for (UIThreadGroup uiThreadGroup : this.m_threadGroups) {
            if (structural) {
                uiThreadGroup.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
            }
            uiThreadGroup.getRenderInfo().setNonStructuralDirty(true);
            for (UIThread uiThread : uiThreadGroup.getThreads()) {
                if (structural) {
                    uiThread.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
                }
                uiThread.getRenderInfo().setNonStructuralDirty(true);
                this.markLevelInstancesStructuralDirty(uiThread.getLevelInstances(), structural);
            }
            for (RenderInfo renderInfo : uiThreadGroup.getRenderInfos()) {
                if (structural) {
                    renderInfo.getSampleComponent().getSampleInfo().setStructuralDirty(true);
                }
                renderInfo.setNonStructuralDirty(true);
            }
        }
        this.getGarbageCollector().getEvenRenderInfo().setNonStructuralDirty(true);
        this.getGarbageCollector().getOddRenderInfo().setNonStructuralDirty(true);
        if (structural) {
            this.getGarbageCollector().getSampler().getSampleInfo().setStructuralDirty(structural);
        }
        this.markLevelInstancesStructuralDirty(this.getGarbageCollector().getLevelInstances(), structural);
        this.fireChange(structural);
    }

    public void markLevelInstancesStructuralDirty(Collection instances, boolean structural) {
        for (UILevelInstance uiLevelInstance : instances) {
            if (structural) {
                uiLevelInstance.getRenderInfo().getSampleComponent().getSampleInfo().setStructuralDirty(true);
            }
            uiLevelInstance.getRenderInfo().setNonStructuralDirty(true);
        }
    }

    public void fireChange(boolean structural) {
        for (UIComponentChange f : this.m_listeners) {
            f.onUIComponentChange(structural);
        }
    }

    public Collection getThreadGroups() {
        return this.m_threadGroups;
    }

    void setThreads(Collection threads) {
        this.m_threads = threads;
    }

    public void setEventTypes(Collection eventTypes) {
        this.m_eventTypes = eventTypes;
    }

    public void setThreadGroups(ArrayList threadGroups) {
        this.m_threadGroups = threadGroups;
    }

    public void setLevelTypes(Collection collection) {
        this.m_LevelTypes = collection;
    }

    public Collection getLevelTypes() {
        return this.m_LevelTypes;
    }

    public UIGarbageCollector getGarbageCollector() {
        return this.m_garbageCollector;
    }

    public Collection getProducers() {
        return this.m_producer;
    }

    public Collection getThreads() {
        return this.m_threads;
    }

    public Collection getEventTypes() {
        return this.m_eventTypes;
    }

    public void setGarbageCollector(UIGarbageCollector uiGarbageCollector) {
        this.m_garbageCollector = uiGarbageCollector;
    }

    public void dispose() {
        this.m_listeners.clear();
    }

    public Collection getValueTypes() {
        return this.m_uiEventValueTypes;
    }

    public static interface UIComponentChange {
        public void onUIComponentChange(boolean var1);
    }
}

