/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.api.PathDescriptorRepository;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.ITrackDescriptor;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import com.jrockit.mc.flightrecorder.spi.ITrackView;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIComponents;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIEventType;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIProducer;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIComponentBuilder {
    private static final Object THREAD = "platformId";
    private final FlightRecording m_recording;
    private final UIModel m_uiModel;
    private final HashMap m_eventTypeMap = new HashMap();
    private final ArrayList m_levelInstances = new ArrayList(200);

    public UIComponentBuilder(UIModel uiModel, FlightRecording recording) {
        this.m_recording = recording;
        this.m_uiModel = uiModel;
    }

    private void addProducers(UIComponents uiComponents) {
        for (IProducer producer : this.getProducers()) {
            UIProducer uiProducer = new UIProducer(producer);
            uiComponents.getProducers().add(uiProducer);
            this.addEventTypes(uiComponents, uiProducer);
        }
        this.getUIModel().getUIComponents().setEventTypes(this.m_eventTypeMap.values());
    }

    private List<IProducer> getProducers() {
        return this.m_recording.getEventTypeRepository().getProducers();
    }

    private Collection<UILevelInstance> createUILevelInstances(ITrackDescriptor desc) {
        HashMap<String, ArrayList<ITrackDescriptor>> pathFolders = new HashMap<String, ArrayList<ITrackDescriptor>>();
        for (ITrackDescriptor de : desc.getChildren()) {
            String folder = this.getFolder(de.getIdentifier());
            ArrayList<ITrackDescriptor> descs = (ArrayList<ITrackDescriptor>)pathFolders.get(folder);
            if (descs == null) {
                descs = new ArrayList<ITrackDescriptor>();
                pathFolders.put(folder, descs);
            }
            descs.add(de);
        }
        ArrayList<UILevelInstance> uiLevelInstances = new ArrayList<UILevelInstance>();
        for (String key : pathFolders.keySet()) {
            ITrackView tw = this.m_recording.createTrackView();
            List decss = (List)pathFolders.get(key);
            tw.setTracks((Collection)decss);
            PathDescriptor ps = PathDescriptorRepository.getDefault().createPathDescriptor(key, null);
            UILevelInstance uiLevelInstance = new UILevelInstance(tw, ps.getName(), ps.getColor());
            uiLevelInstances.add(uiLevelInstance);
        }
        this.m_levelInstances.add(uiLevelInstances);
        return uiLevelInstances;
    }

    private void addThreads(UIComponents uiComponents) {
        HashMap<String, UIThreadGroup> groups = new HashMap<String, UIThreadGroup>();
        ArrayList<UIThread> threads = new ArrayList<UIThread>();
        ITrackRepository tr = this.m_recording.getTrackRepository();
        Collection all = tr.getTrackDescriptors();
        for (ITrackDescriptor d : all) {
            if (!THREAD.equals(d.getType())) continue;
            Map properties = d.getProperties();
            IMCThread t = (IMCThread)properties.get("thread");
            String threadGroup = t != null ? t.getThreadGroup() : "No Thread Group";
            UIThreadGroup group = (UIThreadGroup)groups.get(threadGroup);
            if (group == null) {
                group = new UIThreadGroup(threadGroup);
                groups.put(threadGroup, group);
            }
            UIThread uiThread = new UIThread(t);
            group.addThread(uiThread);
            threads.add(uiThread);
            uiThread.addLevelInstances(this.createUILevelInstances(d));
        }
        uiComponents.setThreadGroups(new ArrayList(groups.values()));
        uiComponents.setThreads(threads);
    }

    private String getFolder(String identifier) {
        int index;
        if (identifier.length() != 0 && (index = identifier.lastIndexOf("/")) > 0) {
            return identifier.substring(0, index);
        }
        return identifier;
    }

    private void addEventTypes(UIComponents uiComponents, UIProducer uiProducer) {
        for (IEventType eventType : uiProducer.getProducer().getEventTypes()) {
            UIEventType uiEventType = new UIEventType(this.m_uiModel, eventType, uiProducer);
            this.m_eventTypeMap.put(eventType, uiEventType);
        }
    }

    public void populate(UIComponents uiComponents) {
        this.addProducers(uiComponents);
        this.addThreads(uiComponents);
    }

    private UIModel getUIModel() {
        return this.m_uiModel;
    }
}

