/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SelectionVisitor
implements IVisitor {
    private final IRange m_range;
    private final IRangeFilter m_rangeFilter;
    private final ArrayList m_selection = new ArrayList(1000);

    public SelectionVisitor(IRange range, IRangeFilter filter) {
        this.m_range = range;
        this.m_rangeFilter = filter;
    }

    public boolean visit(UIThreadGroup uiThreadGroup) {
        boolean result = false;
        Iterator it = uiThreadGroup.getThreads().iterator();
        while (it.hasNext()) {
            if (!this.visit((UIThread)it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean visit(UIThread uiTHread) {
        boolean result = false;
        Iterator it = uiTHread.getLevelInstances().iterator();
        while (it.hasNext()) {
            if (!this.visit((UILevelInstance)it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean visit(UILevelInstance uiLevelInstance) {
        boolean result = false;
        Iterator it = uiLevelInstance.iterator(this.m_rangeFilter, this.m_range, RangeSelection.NORMAL);
        while (it.hasNext()) {
            if (!this.visit((IEvent)it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean visit(UIGarbageCollector uiGarbageCollector) {
        boolean result = false;
        Iterator it = uiGarbageCollector.getLevelInstances().iterator();
        while (it.hasNext()) {
            if (!this.visit((UILevelInstance)it.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean visit(IEvent event) {
        if (this.m_rangeFilter.accept((IRange)event)) {
            this.m_selection.add(event);
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_selection.clear();
    }

    public List getSelection() {
        return this.m_selection;
    }
}

