/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfig;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ObjectLocator;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderLayout;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderLayoutData;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIGarbageCollector;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UILevelInstance;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIModel;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.VisibilityVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ThreadRenderer {
    final RenderLayoutData EDGE = new RenderLayoutData(0, 1, 3);
    final RenderLayoutData THREAD_BACKGROUND = new RenderLayoutData(0, 15, 2);
    final RenderLayoutData LEVEL = new RenderLayoutData(2, 999, 1);
    final RenderLayoutData LEVEL_PADDING = new RenderLayoutData(0, 3, 3);
    private IRange m_range;
    private UIModel m_uModel;
    private Visitable m_input;
    protected int m_leftEdge;
    protected int m_rightEdge;
    protected int m_index;
    private int m_scanLine;
    private int m_scanLinewidth;
    private int m_height;
    private int m_y;
    private final RenderLayout m_renderLayout = new RenderLayout(1000);
    private final ObjectLocator m_objectLocator;
    private final ChartConfig m_chartConfig;
    private final VisibilityVisitor m_visibilityVisitor;

    public ThreadRenderer(ObjectLocator locator, ChartConfig config, VisibilityVisitor visibilityVisitor) {
        this.m_objectLocator = locator;
        this.m_chartConfig = config;
        this.m_visibilityVisitor = visibilityVisitor;
    }

    public void render() {
        this.setRange(this.getUIModel().getRangeMananger().getSelectedRange());
        if (this.getGC().getSampler().needsStructuralRefresh(this.getSelectedRange(), this.getScanLineWidth())) {
            this.updateGC();
        }
        if (this.getInput() instanceof UIThread) {
            UIThread uiThread = (UIThread)this.getInput();
            this.setScanLineBoundary(uiThread.getRange());
            this.renderThread(uiThread, this.getHeight());
        }
        if (this.getInput() instanceof UIThreadGroup) {
            this.renderBackdrop(this.getHeight(), this.getGC());
        }
        if (this.getInput() instanceof UIGarbageCollector) {
            UIGarbageCollector uiGarbageCollector = (UIGarbageCollector)this.getInput();
            this.setScanLineBoundary(this.getSelectedRange());
            this.renderGarbageCollection(uiGarbageCollector);
        }
    }

    private void updateGC() {
        CompositeRangeSampler sampler = this.getGC().getSampler();
        sampler.getSampleInfo().setSize(this.getScanLineWidth());
        sampler.getSampleInfo().setRange(this.getSelectedRange());
        sampler.getSampleInfo().clear();
        boolean showWorkSetOnly = this.getFilter().getShowOnlyWorkSet();
        this.getFilter().setShowOnlyWorkSet(false);
        sampler.sample(this.getFilter());
        this.getFilter().setShowOnlyWorkSet(showWorkSetOnly);
        for (UILevelInstance uil : this.getGC().getLevelInstances()) {
            uil.getRenderInfo().setNonStructuralDirty(true);
        }
        this.getGC().getEvenRenderInfo().setNonStructuralDirty(true);
        this.getGC().getOddRenderInfo().setNonStructuralDirty(true);
        if (!this.getChartConfig().isGCBackdropVisible()) {
            sampler.getSampleInfo().clear();
        }
    }

    public ChartConfig getChartConfig() {
        return this.m_chartConfig;
    }

    private void renderGarbageCollection(UIGarbageCollector uiGarbageCollector) {
        this.renderLevels(this.getVisibleRenderInfos(uiGarbageCollector.getLevelInstances()));
    }

    private UIGarbageCollector getGC() {
        return this.getUIModel().getUIComponents().getGarbageCollector();
    }

    private void renderThread(UIThread uiThread, int height) {
        this.renderLevels(this.getVisibleRenderInfos(uiThread.getLevelInstances()));
    }

    private void setScanLineBoundary(IRange range) {
        this.m_leftEdge = this.getPixelIndex(range.getStartTimestamp());
        this.m_rightEdge = this.getPixelIndex(range.getEndTimestamp());
    }

    private int getPixelIndex(long d) {
        if (this.getScanLineWidth() != 0) {
            if (d == -4611686018427387904L) {
                return -1073741824;
            }
            if (d == -4611686018427387904L) {
                return 0x3FFFFFFF;
            }
            if (d < this.getSelectedRange().getStartTimestamp()) {
                return -1073741824;
            }
            if (d > this.getSelectedRange().getEndTimestamp()) {
                return 0x3FFFFFFF;
            }
            long s = d - this.getSelectedRange().getStartTimestamp();
            double selectedWidth = this.getSelectedRange().getDuration();
            double pixelDelta = selectedWidth / (double)this.getScanLineWidth();
            if (pixelDelta != 0.0) {
                return (int)((double)s / pixelDelta);
            }
        }
        return -1073741824;
    }

    public int getStartIndex() {
        return this.m_leftEdge;
    }

    public int getEndIndex() {
        return this.m_rightEdge;
    }

    protected abstract void renderText(String var1, int var2, int var3);

    protected void renderComponent(RenderInfo renderingInfo, int height) {
        if (renderingInfo.getSampleComponent().needsStructuralRefresh(this.getSelectedRange(), this.getScanLineWidth())) {
            ISampler sampler = renderingInfo.getSampleComponent();
            sampler.getSampleInfo().setSize(this.getScanLineWidth());
            sampler.getSampleInfo().setRange(this.getSelectedRange());
            sampler.getSampleInfo().clear();
            sampler.sample(this.getFilter());
            renderingInfo.setNonStructuralDirty(true);
        }
        if (this.m_index % 2 == 0) {
            this.renderNativeComponent(renderingInfo, this.getUIModel().getUIComponents().getGarbageCollector().getEvenRenderInfo(), height);
        } else {
            this.renderNativeComponent(renderingInfo, this.getUIModel().getUIComponents().getGarbageCollector().getOddRenderInfo(), height);
        }
    }

    private VisibilityVisitor getFilter() {
        return this.m_visibilityVisitor;
    }

    protected abstract void renderNativeComponent(RenderInfo var1, RenderInfo var2, int var3);

    protected abstract void renderEdge(int var1, Visitable var2);

    protected abstract void setRenderingContext(Object var1);

    protected void renderBackdrop(int height, Visitable object) {
        if (this.m_index % 2 == 0) {
            this.renderNativeComponent(null, this.getGC().getEvenRenderInfo(), height);
        } else {
            this.renderNativeComponent(null, this.getGC().getOddRenderInfo(), height);
        }
        this.increaseScanLine(height, object);
    }

    private Collection getVisibleRenderInfos(Collection levelInstanceCollection) {
        ArrayList<UILevelInstance> list = new ArrayList<UILevelInstance>(levelInstanceCollection.size());
        VisibilityVisitor visitor = this.getVisibilityVisitor();
        for (UILevelInstance object : levelInstanceCollection) {
            if (!visitor.visit(object)) continue;
            list.add(object);
        }
        return list;
    }

    private VisibilityVisitor getVisibilityVisitor() {
        return this.m_visibilityVisitor;
    }

    private void renderLevels(Collection uiLevelInstances) {
        int levelCount = uiLevelInstances.size();
        if (levelCount == 0) {
            this.renderBackdrop(this.getHeight(), this.getGC());
            return;
        }
        this.m_renderLayout.clear();
        this.m_renderLayout.addLayoutData(this.THREAD_BACKGROUND);
        Iterator layoutIt = uiLevelInstances.iterator();
        while (layoutIt.hasNext()) {
            layoutIt.next();
            this.m_renderLayout.addLayoutData(this.EDGE);
            this.m_renderLayout.addLayoutData(this.LEVEL);
            this.m_renderLayout.addLayoutData(this.EDGE);
            if (!layoutIt.hasNext()) continue;
            this.m_renderLayout.addLayoutData(this.LEVEL_PADDING);
        }
        this.m_renderLayout.addLayoutData(this.THREAD_BACKGROUND);
        this.m_renderLayout.computeSizes(this.getHeight());
        int i = 0;
        this.renderBackdrop(this.m_renderLayout.getData((int)i++).size, this.getInput());
        Iterator it = uiLevelInstances.iterator();
        while (it.hasNext()) {
            UILevelInstance instance = (UILevelInstance)it.next();
            RenderInfo renderInfo = instance.getRenderInfo();
            this.renderEdge(this.m_renderLayout.getData((int)i++).size, null);
            int h = this.m_renderLayout.getData((int)i++).size;
            this.renderComponent(renderInfo, h);
            this.increaseScanLine(h, instance);
            this.renderEdge(this.m_renderLayout.getData((int)i++).size, null);
            if (!it.hasNext()) continue;
            this.renderBackdrop(this.m_renderLayout.getData((int)i++).size, this.getInput());
        }
        this.renderBackdrop(this.m_renderLayout.getData((int)i++).size, this.getInput());
    }

    public Visitable getInput() {
        return this.m_input;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public UIModel getUIModel() {
        return this.m_uModel;
    }

    public ObjectLocator getObjectLocator() {
        return this.m_objectLocator;
    }

    public void setUIModel(UIModel model) {
        this.m_uModel = model;
    }

    protected IRange getSelectedRange() {
        return this.m_range;
    }

    protected IRange getTotalRange() {
        return this.m_uModel.getRangeMananger().getTotalRange();
    }

    void setRange(IRange range) {
        this.m_range = range;
    }

    protected int getScanLineWidth() {
        return this.m_scanLinewidth;
    }

    public void setScanLine(int i) {
        this.m_scanLine = i;
    }

    protected int getScanLine() {
        return this.m_scanLine;
    }

    public void setScanLineWidth(int width) {
        this.m_scanLinewidth = width;
    }

    public void setInput(Visitable input) {
        this.m_input = input;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    protected void increaseScanLine(int v, Visitable object) {
        int n = 0;
        while (n < v) {
            this.m_objectLocator.setObjectAtPosition(this.m_y + n + this.m_scanLine, object);
            ++n;
        }
        this.m_scanLine += v;
    }

    public void setCoord(int xt, int y) {
        this.m_y = y;
    }
}

