/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ColorFunction;
import java.awt.Color;

public class InterpolatedColorFunction
extends ColorFunction {
    private static final int SIZE = 256;
    private final int[] lookup = new int[256];
    private double m_min = 0.0;
    private double m_max = 1.0;
    private double m_delta = this.m_max - this.m_min;

    public InterpolatedColorFunction(MCColor min, MCColor max) {
        super(min, max);
        double r_delta = (double)(max.getRed() - min.getRed()) / 256.0;
        double g_delta = (double)(max.getGreen() - min.getGreen()) / 256.0;
        double b_delta = (double)(max.getBlue() - min.getBlue()) / 256.0;
        double r = min.getRed();
        double g = min.getGreen();
        double b = min.getBlue();
        int n = 0;
        while (n < 256) {
            this.lookup[n] = new Color((int)(r += r_delta), (int)(g += g_delta), (int)(b += b_delta)).getRGB();
            ++n;
        }
    }

    protected double squareRoot(double d) {
        return 256.0 * Math.sqrt(d / 256.0);
    }

    protected double linear(double d) {
        return d;
    }

    protected double box(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d >= 256.0) {
            return 255.0;
        }
        return d;
    }

    protected double exponential(double d) {
        return this.box(256.0 * (Math.pow(2.0, d / 256.0) - 1.0));
    }

    public void setRange(double min, double max) {
        this.m_min = min;
        this.m_max = max;
        this.m_delta = max - min;
    }

    public int evaluate(double x) {
        if (x <= this.m_min) {
            return this.lookup[0];
        }
        if (x >= this.m_max) {
            return this.lookup[255];
        }
        return this.lookup[(int)(256.0 * (x - this.m_min) / this.m_delta)];
    }
}

