/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfig;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.AWTImageMaker;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ObjectLocator;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ThreadRenderer;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.VisibilityVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import java.awt.Color;
import java.awt.Graphics2D;

public class AWTRenderer
extends ThreadRenderer {
    private Graphics2D m_graphics2D;

    public AWTRenderer(ObjectLocator locator, ChartConfig config, VisibilityVisitor visitor) {
        super(locator, config, visitor);
    }

    public void setRenderingContext(Object context) {
        this.m_graphics2D = (Graphics2D)context;
    }

    private Graphics2D getGraphic2D() {
        return this.m_graphics2D;
    }

    protected void renderText(String text, int a, int b) {
        this.getGraphic2D().drawString(text, a, b);
    }

    protected void renderNativeComponent(RenderInfo forgroundRenderingInfo, RenderInfo backgroundRenderingInfo, int height) {
        if (height == 0) {
            return;
        }
        RenderInfo info = forgroundRenderingInfo != null ? forgroundRenderingInfo : backgroundRenderingInfo;
        AWTImageMaker imageMaker = (AWTImageMaker)info.getImageMaker();
        if (imageMaker == null) {
            imageMaker = new AWTImageMaker();
            info.setImageMaker(imageMaker);
        }
        if (info.isNonStructuralDirty()) {
            ISampler b;
            ISampler a = forgroundRenderingInfo == null ? null : forgroundRenderingInfo.getSampleComponent();
            ISampler iSampler = b = backgroundRenderingInfo == null ? null : backgroundRenderingInfo.getSampleComponent();
            if (info == backgroundRenderingInfo) {
                imageMaker.setUp(a, b, this.getScanLineWidth() + 1, this.getScanLineWidth() + 1);
            } else {
                imageMaker.setUp(a, b, this.getStartIndex(), this.getEndIndex());
            }
            if (a != null) {
                imageMaker.setMissingForegroundColor(forgroundRenderingInfo.getColor());
            }
            if (b != null) {
                imageMaker.setBackgroundColorFunction(backgroundRenderingInfo.getColorFunction());
            }
            imageMaker.rebuild(this.getGraphic2D());
            info.setNonStructuralDirty(false);
        }
        int n = 0;
        while (n < height) {
            if (n / 2 % 2 == 0) {
                this.getGraphic2D().drawImage(imageMaker.getSecondImage(), 0, this.getScanLine() + n, Color.BLACK, null);
            } else {
                this.getGraphic2D().drawImage(imageMaker.getImage(), 0, this.getScanLine() + n, Color.BLACK, null);
            }
            ++n;
        }
    }

    protected void renderEdge(int height, Visitable object) {
        if (height > 0) {
            int h = height;
            int index = this.getScanLine();
            this.renderBackdrop(height, object);
            this.getGraphic2D().setColor(this.getChartConfig().getEdgeColor());
            if (this.m_leftEdge == 0x3FFFFFFF || this.m_rightEdge == -1073741824) {
                return;
            }
            int l = Math.max(0, this.m_leftEdge);
            int r = Math.min(this.getScanLineWidth(), this.m_rightEdge);
            this.getGraphic2D().fillRect(l, index, r - l + 1, index + h - 1);
        }
    }
}

