/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ColorFunction;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class AWTImageMaker {
    private ISampler m_forgroundSampler;
    private ISampler m_backSamplerSampler;
    private BufferedImage m_image;
    private BufferedImage m_cpImage;
    public ColorFunction m_colorFunction;
    private MCColor m_missingForeground;
    protected MCColor m_selectedColor = new MCColor(0, 0, 150);
    protected MCColor m_workSetColor = new MCColor(200, 200, 240);
    private int m_start;
    private int m_end;
    private int[] m_buffer = new int[0];
    private int[] m_secondBuffer = new int[0];

    public BufferedImage getImage() {
        return this.m_image;
    }

    void setUp(ISampler foregroundComponent, ISampler backgroundComponent, int start, int end) {
        this.m_forgroundSampler = foregroundComponent;
        this.m_backSamplerSampler = backgroundComponent;
        this.m_start = start;
        this.m_end = end;
    }

    public void setMissingForegroundColor(MCColor missing) {
        this.m_missingForeground = missing;
    }

    public void setBackgroundColorFunction(ColorFunction colorFunction) {
        this.m_colorFunction = colorFunction;
    }

    public void setSelectedColor(MCColor selectedColor) {
        this.m_selectedColor = selectedColor;
    }

    public void setWorkSetColor(MCColor workSet) {
        this.m_workSetColor = workSet;
    }

    public void rebuild(Graphics2D graphics2D) {
        int begin;
        int blackRGB = Color.BLACK.getRGB();
        int size = 0;
        IRange[] f_maxRAnges = null;
        double[] b_maxValues = null;
        if (this.m_forgroundSampler != null) {
            f_maxRAnges = this.m_forgroundSampler.getSampleInfo().getMaxRanges();
            size = this.m_forgroundSampler.getSampleInfo().getSize();
        }
        if (this.m_backSamplerSampler != null) {
            b_maxValues = this.m_backSamplerSampler.getSampleInfo().getTotal();
            size = this.m_backSamplerSampler.getSampleInfo().getSize();
        }
        if (this.m_image == null || this.m_image.getWidth() != size) {
            GraphicsConfiguration config = graphics2D.getDeviceConfiguration();
            this.m_image = config.createCompatibleImage(size, 1);
            this.m_cpImage = config.createCompatibleImage(size, 1);
        }
        if (this.m_buffer.length != size) {
            this.m_buffer = new int[size];
            this.m_secondBuffer = new int[size];
        }
        int n = 0;
        while (n < this.m_start - 1 && n < size) {
            this.m_secondBuffer[n] = this.m_buffer[n] = this.m_colorFunction.evaluate(b_maxValues[n]);
            ++n;
        }
        if (this.m_forgroundSampler != null) {
            if (this.m_start > 0 && this.m_start < size) {
                this.m_secondBuffer[this.m_start] = this.m_buffer[this.m_start] = blackRGB;
            }
            begin = Math.max(this.m_start + 1, 0);
            IEvent last = null;
            int dec = 0;
            int n2 = begin;
            while (n2 < this.m_end && n2 < size) {
                IEvent foregroundEvent = (IEvent)f_maxRAnges[n2];
                if (last == foregroundEvent) {
                    if (dec < 0) {
                        dec += 3;
                    }
                } else if (n2 != 0) {
                    dec = -30;
                }
                if (foregroundEvent == null) {
                    this.m_secondBuffer[n2] = this.m_buffer[n2] = this.m_missingForeground.getAWTColor().getRGB();
                } else {
                    if ((foregroundEvent.getBitField() & 0x10) > 0) {
                        this.m_buffer[n2] = GraphHelper.SELECTED_COLOR.getAWTColor().getRGB();
                    } else {
                        Color o = foregroundEvent.getEventType().getColor();
                        Color b = new Color(Math.max(o.getRed() + dec, 0), Math.max(o.getGreen() + dec, 0), Math.max(o.getBlue() + dec, 0));
                        this.m_buffer[n2] = b.getRGB();
                    }
                    this.m_secondBuffer[n2] = last != foregroundEvent && n2 != 0 ? blackRGB : this.m_buffer[n2];
                }
                last = foregroundEvent;
                ++n2;
            }
            if (this.m_end > 0 && this.m_end < size - 1) {
                this.m_secondBuffer[this.m_end] = this.m_buffer[this.m_end] = blackRGB;
            }
        }
        int n3 = begin = Math.max(this.m_end + 1, 0);
        while (n3 < size) {
            this.m_secondBuffer[n3] = this.m_buffer[n3] = this.m_colorFunction.evaluate(b_maxValues[n3]);
            ++n3;
        }
        this.m_image.setRGB(0, 0, size, 1, this.m_buffer, 0, size);
        this.m_cpImage.setRGB(0, 0, size, 1, this.m_secondBuffer, 0, size);
    }

    public Image getSecondImage() {
        return this.m_cpImage;
    }
}

