/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.ValueFormatter;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class XRangeRuler
extends Canvas {
    private int startPixel = 0;
    private int endMargin = 0;
    private int markLineHeight = 2;
    private int baseLineYPos;
    private int pixelStep = 10;
    private long startInNs;
    private long rangeInNs;
    private ValueFormatter formatter;
    private int firstDrawnX = Integer.MAX_VALUE;

    public XRangeRuler(Composite parent, int style, final long recStartNanos) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                XRangeRuler.this.paint(e);
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (e.x >= XRangeRuler.this.startPixel && e.x < XRangeRuler.this.getSize().x - XRangeRuler.this.endMargin) {
                    long time = XRangeRuler.this.getValueAtPixel(e.x - XRangeRuler.this.startPixel, XRangeRuler.this.getSize().x - XRangeRuler.this.endMargin - XRangeRuler.this.startPixel - 1);
                    long sdiv = 1000000000L;
                    long sinceRecordingStart = time - recStartNanos;
                    int min = (int)(sinceRecordingStart / (60L * sdiv));
                    int sec = (int)(sinceRecordingStart % (60L * sdiv) / sdiv);
                    String mString = String.valueOf(min < 10 ? "0" : "") + Integer.toString(min);
                    String sString = String.valueOf(sec < 10 ? "0" : "") + Integer.toString(sec);
                    XRangeRuler.this.setToolTipText(String.valueOf(XRangeRuler.this.formatter.getFormattedString(time, 5)) + ":" + XRangeRuler.this.formatter.getFormattedString(time, 3) + " (h:m:s:ms)\n" + Messages.TRACK_COMPONENT_X_RANGE_RULES_TOOLTIP_SINCE_RECORDING_START_TEXT + mString + ":" + sString + " (m:s)");
                }
            }
        });
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        FontMetrics fm = gc.getFontMetrics();
        this.baseLineYPos = fm.getHeight();
        gc.dispose();
        this.formatter = new ValueFormatter();
    }

    public void setRange(long startInNs, long endInNs) {
        this.startInNs = startInNs;
        this.rangeInNs = endInNs - startInNs;
        this.formatter.setRange(this.rangeInNs);
    }

    public int getHeight() {
        return this.baseLineYPos + this.markLineHeight * 2 + 1;
    }

    public void setStartPixel(int pixelPos) {
        this.startPixel = pixelPos;
    }

    public void setEndMargin(int margin) {
        this.endMargin = margin;
    }

    public void paint(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        int width = rect.width - this.endMargin - this.startPixel - 1;
        if (width <= 1) {
            return;
        }
        Color c = new Color((Device)Display.getCurrent(), GraphHelper.DEFAULT_FOREGROUND_COLOR.getRGBColor());
        e.gc.setForeground(c);
        e.gc.drawLine(this.startPixel, this.baseLineYPos, this.startPixel + width, this.baseLineYPos);
        int stepNum = width / this.pixelStep;
        float decimalStep = (float)this.pixelStep + (float)(width % this.pixelStep) / (float)stepNum;
        this.firstDrawnX = Integer.MAX_VALUE;
        int markNum = 0;
        float currentPixel = 0.0f;
        while (Math.round(currentPixel) <= width) {
            int lineHeight = this.markLineHeight;
            if (markNum++ % 5 == 0) {
                lineHeight = 2 * this.markLineHeight;
                this.drawText(e.gc, this.getValueAtPixel(currentPixel, width), Math.round(currentPixel) + this.startPixel, 0);
            }
            e.gc.drawLine(Math.round(currentPixel) + this.startPixel, this.baseLineYPos, Math.round(currentPixel) + this.startPixel, this.baseLineYPos + lineHeight);
            currentPixel += decimalStep;
        }
        String unitString = this.formatter.getCurrentUnitString();
        int textWidth = this.getTextWidth(e.gc, unitString);
        e.gc.drawText(unitString, this.firstDrawnX - textWidth - 2, 0);
        c.dispose();
    }

    private int getTextWidth(GC gc, String text) {
        int textWidth = 0;
        int i = 0;
        while (i < text.length()) {
            textWidth += gc.getCharWidth(text.charAt(i));
            ++i;
        }
        return textWidth;
    }

    private long getValueAtPixel(double pixel, int width) {
        double percentageOfRange = pixel / (double)width;
        long fractionInNs = (long)((double)this.rangeInNs * percentageOfRange);
        return fractionInNs + this.startInNs;
    }

    private void drawText(GC gc, long nanos, int midX, int y) {
        String val = this.formatter.getFormattedString(nanos);
        int textWidth = this.getTextWidth(gc, val);
        int x = midX - textWidth / 2;
        gc.drawText(val, x, 0);
        if (x < this.firstDrawnX) {
            this.firstDrawnX = x;
        }
    }
}

