/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import java.text.SimpleDateFormat;
import java.util.Date;

public class ValueFormatter {
    public static final long NANOSECOND = 1L;
    public static final long MICROSECOND = 1000L;
    public static final long MILLISECOND = 1000000L;
    public static final long SECOND = 1000000000L;
    public static final long MINUTE = 60000000000L;
    public static final long FIVE_MINUTES = 300000000000L;
    public static final long QUARTER_HOUR = 900000000000L;
    public static final long THIRD_HOUR = 1200000000000L;
    public static final long HALF_HOUR = 1800000000000L;
    public static final long HOURS = 3600000000000L;
    public static final long QUARTER_DAY = 21600000000000L;
    public static final long HALF_DAY = 43200000000000L;
    public static final long DAY = 86400000000000L;
    public static final long WEEK = 604800000000000L;
    public static final long MONTH = 2419200000000000L;
    public static final long YEAR = 31536000000000000L;
    public static final long DEFAULT_RANGE = 60000000000L;
    private static final long[] RANGE_ARRAY = new long[]{1L, 1000L, 1000000L, 1000000000L, 10000000000L, 600000000000L, 172800000000000L, 1209600000000000L, 6048000000000000L, 2419200000000000L, 31536000000000000L, Long.MAX_VALUE};
    private static final String[] FORMATTING_STRINGS;
    private static final String[] UNIT_STRINGS;
    private static SimpleDateFormat[] m_formatterArray;
    long rangeToFormat;
    int currentRangeIndex;
    private Date m_dateCache = new Date();

    static {
        String[] stringArray = new String[11];
        stringArray[2] = "S";
        stringArray[3] = "s:SSS";
        stringArray[4] = "mm:ss";
        stringArray[5] = "HH:mm";
        stringArray[6] = "EEE HH:mm";
        stringArray[7] = "EEE";
        stringArray[8] = "ww";
        stringArray[9] = "MMMMM";
        stringArray[10] = "yyyy";
        FORMATTING_STRINGS = stringArray;
        UNIT_STRINGS = new String[]{"(ns)", "(\u00b5s)", "(ms)", "(s:ms)", "(m:s)", "(h:m)", "", "", "", "", "", "(week)", "", "", "", ""};
        m_formatterArray = new SimpleDateFormat[FORMATTING_STRINGS.length];
    }

    public void setRange(long rangeInNs) {
        this.rangeToFormat = rangeInNs;
        this.currentRangeIndex = this.getRangeIndex(this.rangeToFormat);
    }

    public String getFormattedString(long valueInNs) {
        if (this.currentRangeIndex <= 1) {
            if (this.currentRangeIndex == 0) {
                return Long.toString(valueInNs % 1000L);
            }
            return Long.toString(valueInNs / 1000L % 1000L);
        }
        return this.getFormattedString(valueInNs, this.currentRangeIndex);
    }

    public String getCurrentUnitString() {
        return this.getUnitString(this.currentRangeIndex);
    }

    String getUnitString(int rangeIndex) {
        return UNIT_STRINGS[rangeIndex];
    }

    private int getRangeIndex(long range) {
        int i = 0;
        while (i < RANGE_ARRAY.length) {
            if (range < RANGE_ARRAY[i]) {
                int rangeIndex = i >= 1 ? i - 1 : 0;
                return rangeIndex;
            }
            ++i;
        }
        return -1;
    }

    private synchronized SimpleDateFormat getDateFormat(int rangeIndex) {
        if (m_formatterArray[rangeIndex] == null) {
            ValueFormatter.m_formatterArray[rangeIndex] = new SimpleDateFormat(FORMATTING_STRINGS[rangeIndex]);
        }
        return m_formatterArray[rangeIndex];
    }

    String getFormattedString(long timeInNs, int rangeIndex) {
        this.m_dateCache.setTime(timeInNs / 1000000L);
        return this.getDateFormat(rangeIndex).format(this.m_dateCache);
    }
}

