/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.RangeManager;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerModel;
import java.util.Observable;
import java.util.Observer;

public class ThreadGraphRulerModel
implements Observer {
    private final RangeManager m_rangeManger;
    private final RulerModel m_rulerModel;
    private long m_nanos1970Position;

    public ThreadGraphRulerModel(RangeManager rangeManger, RulerModel rulerModel) {
        this.m_rangeManger = rangeManger;
        this.m_rulerModel = rulerModel;
        this.m_rulerModel.addObserver(this);
    }

    public void setPosition(long nanosSince1970) {
        this.m_nanos1970Position = nanosSince1970;
    }

    public void updateDeviceInformation(int width, int offset) {
        this.m_rulerModel.setMinimumPosition(offset);
        this.m_rulerModel.setMaximumPosition(width);
        this.updatePosition();
        if (this.m_rulerModel.isVisible()) {
            this.m_rulerModel.notifyObservers(this);
        }
    }

    private void updateFromRuler() {
        long duration = this.m_rangeManger.getCroppedSelectedRange();
        long start = this.m_rangeManger.getSelectedRange().getStartTimestamp();
        int p = this.m_rulerModel.getPosition() - this.m_rulerModel.getMinimumPosition();
        long relativeWorldPosition = (long)p * duration / (long)(this.m_rulerModel.getMaximumPosition() - this.m_rulerModel.getMinimumPosition());
        this.setPosition(start + relativeWorldPosition);
    }

    private void updatePosition() {
        long duration = this.m_rangeManger.getSelectedRange().getDuration();
        long pixelWidth = this.m_rulerModel.getMaximumPosition() - this.m_rulerModel.getMinimumPosition();
        long start = this.m_rangeManger.getSelectedRange().getStartTimestamp();
        long relativeWorldPosition = this.m_nanos1970Position - start;
        double p = (double)pixelWidth / (double)duration;
        int devicePosition = (int)((double)relativeWorldPosition * p + 0.5) + this.m_rulerModel.getMinimumPosition();
        this.m_rulerModel.setPosition(devicePosition);
    }

    public void show() {
        this.m_rulerModel.setPosition((this.m_rulerModel.getMaximumPosition() - this.m_rulerModel.getMinimumPosition()) / 2 + this.m_rulerModel.getMinimumPosition());
        this.m_rulerModel.setVisible(true);
        this.m_rulerModel.notifyObservers();
    }

    public void update(Observable o, Object arg) {
        if (arg != this) {
            this.updateFromRuler();
        }
    }

    public void dispose() {
        this.m_rulerModel.deleteObserver(this);
    }

    public boolean isOnScreen() {
        if (!this.m_rulerModel.isVisible()) {
            return false;
        }
        if (this.m_nanos1970Position < this.m_rangeManger.getSelectedRange().getStartTimestamp()) {
            return false;
        }
        return this.m_nanos1970Position <= this.m_rangeManger.getSelectedRange().getEndTimestamp();
    }
}

