/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.RangeIterator;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeManager {
    private final FlightRecording m_recording;
    private final ListenerList m_selectedRangeListeners = new ListenerList();
    private final IRange m_totalRange;
    private IRange m_selectedRange;

    public RangeManager(FlightRecording recording) {
        this.m_recording = recording;
        this.m_totalRange = this.findMinimumSpan();
        this.m_selectedRange = new Range(this.m_totalRange.getStartTimestamp(), this.m_totalRange.getEndTimestamp());
    }

    private IRange findMinimumSpan() {
        long min = this.m_recording.getRange().getStartTimestamp();
        assert (min > 0L);
        long max = this.m_recording.getRange().getEndTimestamp();
        assert (max > 0L);
        for (IRangeHolder holder : this.getRangeHolders()) {
            IRange first = holder.getFirst();
            assert (first != null);
            if (first != null) {
                min = first.getStartTimestamp() != -4611686018427387904L ? Math.min(min, first.getStartTimestamp()) : Math.min(min, first.getEndTimestamp());
            }
            IRange last = holder.getLast();
            assert (last != null);
            if (last == null) continue;
            max = last.getEndTimestamp() != 0x3FFFFFFFFFFFFFFFL ? Math.max(max, last.getEndTimestamp()) : Math.max(max, first.getStartTimestamp());
        }
        return new Range(min, max);
    }

    public List<IRangeHolder> getRangeHolders() {
        return new ArrayList<IRangeHolder>();
    }

    public RangeIterator getEventsInRange(IRange range, IRangeFilter filter) {
        return new RangeIterator(new ArrayList(), range, filter, RangeSelection.NORMAL);
    }

    public RangeIterator getEventsInSelectedRange() {
        return new RangeIterator(new ArrayList(), this.getSelectedRange(), (IRangeFilter)IRangeHolder.ALWAYS_TRUE_FILTER, RangeSelection.NORMAL);
    }

    public RangeIterator getEventsInSelectedRange(IRangeFilter filter) {
        return new RangeIterator(new ArrayList(), this.getSelectedRange(), filter, RangeSelection.NORMAL);
    }

    public IRange getSelectedRange() {
        return this.m_selectedRange;
    }

    public IRange getTotalRange() {
        return this.m_totalRange;
    }

    boolean sameRange(IRange a, IRange b) {
        if (a.getStartTimestamp() != b.getStartTimestamp()) {
            return false;
        }
        return a.getEndTimestamp() == b.getEndTimestamp();
    }

    public void setSelectedRange(Object source, IRange range) {
        if (!this.sameRange(this.m_selectedRange, range)) {
            this.m_selectedRange = range;
            Object[] listeners = this.m_selectedRangeListeners.getListeners();
            int n = 0;
            while (n < listeners.length) {
                SelectedRangeChange s = (SelectedRangeChange)listeners[n];
                if (s != source) {
                    s.onSelectedRangeChange(range);
                }
                ++n;
            }
        }
    }

    public void dispose() {
        this.m_selectedRangeListeners.clear();
    }

    public Iterator getEventsInTotalRange() {
        return this.getEvents(IRange.INFINITE_RANGE);
    }

    private Iterator getEvents(IRange infiniteRange) {
        return this.m_recording.iterator();
    }

    public void addSelecteRangeChangeListener(SelectedRangeChange listener) {
        this.m_selectedRangeListeners.add((Object)listener);
    }

    public void removeSelecteRangeChangeListener(SelectedRangeChange listener) {
        this.m_selectedRangeListeners.remove((Object)listener);
    }

    public long getCroppedSelectedRange() {
        long duration = this.m_selectedRange.getDuration();
        if (this.m_selectedRange.getDuration() == Long.MAX_VALUE) {
            duration = this.m_recording.getRange().getEndTimestamp() - this.m_recording.getRange().getStartTimestamp();
        }
        return duration;
    }

    public static interface SelectedRangeChange {
        public void onSelectedRangeChange(IRange var1);
    }
}

