/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.NanosTimeSpanField;
import com.jrockit.mc.core.ui.UISettable;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import java.awt.Color;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ChartConfig
implements UISettable {
    private static final String GRAPH_SETTINGS = "latency.graph.settings";
    private static final String DONT_SHOW_GC_BACKDROP = "dontshowgcbackdrop";
    private static final String TOOLTIP_VERBOSITY = "tooltip.verbosity";
    private static final String SHOW_TRANSITIONS = "show.transitions";
    public static final int MINIMUM = 1;
    public static final int NORMAL = 2;
    public static final int FULL = 3;
    public static Field FIELD_TIME = new NanosTimeSpanField(0);
    private static Field[] FIELD_PROTOTYPES = new Field[]{FIELD_TIME};
    private Field[] m_fields = FieldToolkit.instantiateFieldArray((Field[])FIELD_PROTOTYPES);
    private boolean m_showTransitions = false;
    private boolean m_showGCBackdrop = true;
    private int m_tooltipVerbosity = 2;

    static {
        FieldToolkit.initializeFields((String)"com.jrockit.mc.flightrecorder.ui.components.graph.fields", ChartConfig.class);
    }

    public ChartConfig(FlightRecording recording) {
        this.m_fields[0].setInput((Object)recording);
    }

    public Color getEdgeColor() {
        return Color.BLACK;
    }

    public Color getThreadBackgroundColor(int index) {
        return index % 2 == 0 ? GraphHelper.EVEN_COLOR.getAWTColor() : GraphHelper.ODD_COLOR.getAWTColor();
    }

    public void setGCBackdropVisible(boolean showBackdrop) {
        this.m_showGCBackdrop = showBackdrop;
    }

    public boolean isGCBackdropVisible() {
        return this.m_showGCBackdrop;
    }

    public int getTooltipVerbosity() {
        return this.m_tooltipVerbosity;
    }

    public void setTooltipVerbosity(int verbosity) {
        this.m_tooltipVerbosity = verbosity;
    }

    public Field getTimeFormatField() {
        return this.m_fields[0];
    }

    public void loadDialogSettings(IDialogSettings parentSettings) {
        if (parentSettings != null) {
            IDialogSettings settings = parentSettings.getSection(GRAPH_SETTINGS);
            if (settings == null) {
                settings = parentSettings.addNewSection(GRAPH_SETTINGS);
            }
            FieldToolkit.fillFieldsFromDialogSettings((IDialogSettings)settings, (Field[])this.m_fields);
            this.m_showGCBackdrop = !settings.getBoolean(DONT_SHOW_GC_BACKDROP);
            this.m_showTransitions = settings.getBoolean(SHOW_TRANSITIONS);
            try {
                this.m_tooltipVerbosity = settings.getInt(TOOLTIP_VERBOSITY);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void saveDialogSettings(IDialogSettings parentSettings) {
        IDialogSettings settings = parentSettings.getSection(GRAPH_SETTINGS);
        if (settings == null) {
            settings = parentSettings.addNewSection(GRAPH_SETTINGS);
        }
        FieldToolkit.fillDialogSettingsFromFields((Field[])this.m_fields, (IDialogSettings)settings);
        settings.put(DONT_SHOW_GC_BACKDROP, !this.m_showGCBackdrop);
        settings.put(TOOLTIP_VERBOSITY, this.m_tooltipVerbosity);
        settings.put(SHOW_TRANSITIONS, this.m_showTransitions);
    }

    public void setShowTransitions(boolean selection) {
        this.m_showTransitions = selection;
    }

    public boolean getShowTransition() {
        return this.m_showTransitions;
    }
}

