/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.eventtable;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.util.ImageDescriptorImageProvider;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.model.fields.StructuredRowSelection;
import com.jrockit.mc.core.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.core.ui.fields.CommonLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SelectionIteratorFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.eventtable.TableContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.eventtable.TableModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableViewerComponent
extends ColumnViewerComponent
implements INavigatorSelectionChangeListener,
ITypeVisibilityChange,
IEventConsumer {
    public boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    protected ViewModelBuilder createModelBuilder() {
        return new TableModelBuilder(this.getServiceLocator(), this.getRepository(), this.getComponentDescriptor());
    }

    protected StructuredViewer createViewer(Composite parent) {
        Table table = this.getFormToolkit().createTable(parent, 268501762);
        FieldTableViewer viewer = new FieldTableViewer(table, this.getFields());
        viewer.setContentProvider((IContentProvider)new TableContentProvider(this.getRepository()));
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(parent.getDisplay()));
        this.hookSelectionListener(viewer);
        this.hookModelView((ContentViewer)viewer, this.getModelBuilder());
        viewer.setInput((Object)this.getModelBuilder());
        return viewer;
    }

    private FieldLabelProvider createLabelProvider(Display display) {
        if (this.getRepository().hasImage()) {
            return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new ImageDescriptorImageProvider(display, this.getRepository().getImageDescriptor()));
        }
        return new BoldFieldLabelProvider(this.getFields(), (ILabelProvider)new CommonLabelProvider());
    }

    protected IStatus getModelStatus(Object model) {
        String message = this.getModelBuilder().getLastBuildMessage();
        if (message == null) {
            return this.createOKStatus();
        }
        return new Status(2, "com.jrockit.mc.flightrecorder.ui", message);
    }

    protected void refreshViewer(ContentViewer viewer) {
        super.refreshViewer(viewer);
        this.selectAnElement();
    }

    public void selectAnElement() {
        if (this.getViewer().getSelection().isEmpty()) {
            Object[] allelements = ((FieldTableViewer)this.getViewer()).getAllElements();
            if (allelements != null && allelements.length > 0) {
                StructuredRowSelection selection = new StructuredRowSelection((Row)allelements[0], this.getFields());
                this.getViewer().setSelection((ISelection)selection, true);
            }
            this.pushSelection((IStructuredSelection)this.getViewer().getSelection());
        }
    }

    private void pushSelection(IStructuredSelection selection) {
        if (this.getRepository().getRole() == Role.MASTER) {
            SelectionIteratorFactory sif = new SelectionIteratorFactory(selection);
            for (IEventConsumer ec : this.getComponents().getComponentsInAncestorScopes(IEventConsumer.class)) {
                ec.consumeEvents(sif);
            }
        }
    }

    private void hookSelectionListener(FieldTableViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OperativeSetService oss = (OperativeSetService)TableViewerComponent.this.getServiceLocator().getService(OperativeSetService.class);
                oss.setRange(TableViewerComponent.this.getModelBuilder().getView().getRange());
                oss.setEventSelection((IStructuredSelection)event.getSelection());
                TableViewerComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }
}

