/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ColorInput;
import com.jrockit.mc.components.ui.settings.DoubleInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DialMasterDetailFactory
implements IMasterDetailFactory {
    static final String ANIMATED = "animated";
    private final IServiceLocator m_serviceLocator;
    private final DialDescriptorRepository m_configuration;

    public DialMasterDetailFactory(IServiceLocator serviceLocator, DialDescriptorRepository configuration) {
        this.m_serviceLocator = serviceLocator;
        this.m_configuration = configuration;
    }

    public IInput createDetailBaseInput(Shell shell) {
        IInput eventTypeInput = InputFactory.createEventTypeInput(this.m_serviceLocator);
        eventTypeInput.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
                if (status == IInput.STATUS_SETTING_CHANGE) {
                    DialMasterDetailFactory.this.m_configuration.getDialDescriptors().clear();
                }
            }
        });
        return eventTypeInput;
    }

    public List<IInput> createDetailInput() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(InputFactory.createAttributeWithStaticRepository(this.m_serviceLocator, this.m_configuration.getEventTypeDescriptorBase(), false));
        list.add((IInput)InputFactory.createName());
        list.add(InputFactory.createDescription());
        list.add(InputFactory.createAggregator());
        list.add(InputFactory.createColor());
        list.add(this.createAnimated());
        return list;
    }

    public List createDetailList() {
        return this.m_configuration.getDialDescriptors();
    }

    public List<IInput> createMainInputs() {
        ArrayList<IInput> list = new ArrayList<IInput>();
        list.add(InputFactory.createRole(Role.INDEPENDENT));
        list.add(this.createGradientBeginValue());
        list.add(this.createGradientBeginColor());
        list.add(this.createGradientEndValue());
        list.add(this.createGradientEndColor());
        list.add(InputFactory.createUnit(false));
        list.add(InputFactory.createOperativeSetEnabled());
        return list;
    }

    public String createMasterTableTitle() {
        return Messages.DIAL_COMPONENT_MASTER_DETAIL_TITLE;
    }

    public List<Object> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.m_configuration.getEventTypeDescriptorBase();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.DIAL_COMPONENT_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.DIAL_COMPONENT_CONFIGURATION_YOU_MUST_SELECT_AN_EVENT_TYPE);
            return null;
        }
        BrowseForEventAttributeWizard bfeaw = new BrowseForEventAttributeWizard(this.m_serviceLocator, 4, false, eventTypes);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfeaw);
        dialog.setWidthConstaint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            Object[] object = bfeaw.getSelection().toArray();
            ArrayList<Object> list = new ArrayList<Object>();
            int n = 0;
            while (n < object.length) {
                list.add(this.createDialDescriptor((IRetriever)object[n]));
                ++n;
            }
            return list;
        }
        return null;
    }

    public StructuredViewer createTableViewer(Composite parent) {
        FieldTableViewer viewer = new FieldTableViewer(this.createTable(parent), this.createFields());
        viewer.setContentProvider((IContentProvider)new InformationContentProvider());
        viewer.setInput(this.getDialDescriptors());
        return viewer;
    }

    private DialDescriptor createDialDescriptor(IRetriever result) {
        DialDescriptor dialDescriptor = new DialDescriptor();
        dialDescriptor.setName(result.getName());
        dialDescriptor.setDescription(result.getDescription());
        dialDescriptor.setAttributeIdentifier(result.getAttributeIdentifier());
        dialDescriptor.setAnimated(true);
        dialDescriptor.setColor(new MCColor(Color.BLACK));
        dialDescriptor.setUnit(new UnitDescriptor());
        return dialDescriptor;
    }

    private IInput createGradientEndColor() {
        return new ColorInput("gradientEndColor", Messages.DIAL_COMPONENT_GRADIENT_END_COLOR_TEXT);
    }

    private IInput createGradientEndValue() {
        return new DoubleInput("gradientEndValue", Messages.DIAL_COMPONENT_GRADIENT_END_VALUE_TEXT);
    }

    private IInput createGradientBeginValue() {
        return new DoubleInput("gradientBeginValue", Messages.DIAL_COMPONENT_GRADIENT_START_VALUE_TEXT);
    }

    private IInput createGradientBeginColor() {
        return new ColorInput("gradientBeginColor", Messages.DIAL_COMPONENT_GRADIENT_START_COLOR_TEXT);
    }

    private IInput createAnimated() {
        return new BooleanInput(ANIMATED, Messages.DIAL_COMPONENT_ANIMATE_TEXT);
    }

    private Table createTable(Composite parent) {
        return new Table(parent, 268503812);
    }

    private Field[] createFields() {
        return new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    }

    private List<DialDescriptor> getDialDescriptors() {
        return this.m_configuration.getDialDescriptors();
    }

    public List<IInput> createSpecific() {
        return null;
    }

    public String createSpecificTitle() {
        return null;
    }
}

