/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.behaviors.IComponentDecoration;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.accessibility.AccessibilityConstants;
import com.jrockit.mc.core.accessibility.MCAccessibleListener;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.FieldFactory;
import com.jrockit.mc.core.ui.IRefreshable;
import com.jrockit.mc.core.ui.dial.DeviceDescriptionFactory;
import com.jrockit.mc.core.ui.dial.DialFieldInformation;
import com.jrockit.mc.core.ui.dial.DialInformationViewer;
import com.jrockit.mc.core.ui.dial.DialViewer;
import com.jrockit.mc.core.ui.dial.FixedDial;
import com.jrockit.mc.core.ui.dial.IDialInformationProvider;
import com.jrockit.mc.core.ui.dial.IDialProvider;
import com.jrockit.mc.core.ui.dial.MovingDial;
import com.jrockit.mc.core.ui.dial.RefreshController;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DialComponent
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
IComponentDecoration,
IOperativeSetAware {
    private RefreshController m_refreshController;

    public boolean initialize(IServiceLocator serviceLocator) {
        boolean initOK = super.initialize(serviceLocator);
        InformationModelBuilder<DialDescriptor> imb = new InformationModelBuilder<DialDescriptor>(serviceLocator, this.getDialDescriptors(), this.getComponentDescriptor());
        imb.setEventView(this.createView());
        imb.setOperativeSetEnabled(false);
        serviceLocator.registerService(imb);
        return initOK;
    }

    protected InformationModelBuilder<DialDescriptor> getBuilder() {
        return (InformationModelBuilder)this.getServiceLocator().getService(InformationModelBuilder.class);
    }

    private List<DialDescriptor> getDialDescriptors() {
        return this.getRepository().getDialDescriptors();
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.m_refreshController.stop();
        this.getBuilder().stop();
        return super.dispose(serviceLocator);
    }

    public Control createPart(Composite parent) {
        this.m_refreshController = new RefreshController(parent.getDisplay());
        Composite client = this.getFormToolkit().createComposite(parent, 0);
        client.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        MCAccessibleListener cp = new MCAccessibleListener();
        cp.setComponentType(AccessibilityConstants.COMPONENT_TYPE_DIAL);
        cp.setName(this.getComponentDescriptor().getName());
        client.getAccessible().addAccessibleListener((AccessibleListener)cp);
        client.setLayout((Layout)this.createLayout());
        if (this.getRepository().getAllowOperariveSet()) {
            Button button = this.createAllowOperativeSetButton(client, this.getFormToolkit());
            button.setLayoutData((Object)new GridData(131072, 128, true, false));
        }
        GridData gd1 = new GridData(4, 128, true, false);
        DialViewer viewer = this.createDialViewer(client);
        gd1.heightHint = 132;
        viewer.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 128, true, false);
        DialInformationViewer dialInformationViewer = this.createDialInformationViewer(client);
        dialInformationViewer.setLayoutData((Object)gd2);
        this.addDials(viewer, dialInformationViewer);
        this.hookRefreshControllerStart(parent);
        return client;
    }

    private void hookRefreshControllerStart(Composite parent) {
        class StartObserver
        implements Observer {
            private final /* synthetic */ Composite val$parent;

            StartObserver(Composite composite) {
                this.val$parent = composite;
            }

            public void update(Observable o, Object arg) {
                final StartObserver me = this;
                DisplayToolkit.safeAsyncExec((Widget)this.val$parent, (Runnable)new Runnable(){

                    public void run() {
                        DialComponent.this.m_refreshController.start();
                        DialComponent.this.getBuilder().deleteObserver(me);
                    }
                });
            }
        }
        this.getBuilder().addObserver(new StartObserver(parent));
    }

    private Button createAllowOperativeSetButton(Composite parent, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialComponent.this.getBuilder().scheduleRebuild();
            }
        });
        return button;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public void hide() {
        this.m_refreshController.stop();
    }

    protected void refresh() {
        this.getBuilder().scheduleRebuild();
    }

    private IEventTypeView createView() {
        IEventTypeView view = ((FlightRecording)this.getServiceLocator().getService(FlightRecording.class)).createView();
        view.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
        return view;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        this.getBuilder().getView().setRange((IRange)new Range(startTime, endTime));
        this.markDirty();
    }

    private DialInformationViewer createDialInformationViewer(final Composite client) {
        final DialInformationViewer diw = new DialInformationViewer(client, this.getFormToolkit(), 0);
        this.getBuilder().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Map values = (Map)DialComponent.this.getBuilder().getModel();
                for (Map.Entry entry : values.entrySet()) {
                    diw.setInput((String)entry.getKey(), entry.getValue());
                }
                DisplayToolkit.safeAsyncExec((Widget)client, (Runnable)new Runnable(){

                    public void run() {
                        diw.refresh();
                    }
                });
            }
        });
        this.getFormToolkit().adapt((Composite)diw);
        return diw;
    }

    public DialDescriptorRepository getRepository() {
        return (DialDescriptorRepository)this.getComponentSettings().getChildObject("dialConfiguration", DialDescriptorRepository.class);
    }

    private DialViewer createDialViewer(Composite parent) {
        DialViewer viewer = new DialViewer(parent, 0);
        this.getFormToolkit().adapt((Composite)viewer);
        viewer.setToolTipText(this.getComponentDescriptor().getDescription());
        viewer.setTitle(this.getComponentDescriptor().getName());
        viewer.setGradientRange(this.getRepository().getGradientBeginValue(), this.getRepository().getGradientEndValue(), this.getRepository().getGradientBeginColor(), this.getRepository().getGradientEndColor());
        UnitDescriptor unit = this.getRepository().getUnit();
        if (unit.getDisplayUnit().getContentType().equals(UnitLookup.PERCENTAGE)) {
            viewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)"percentage"));
        } else if (unit.getDisplayUnit().getContentType().equals(UnitLookup.MEMORY)) {
            viewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)"bytes"));
        } else if (unit.getDisplayUnit().getContentType().equals(UnitLookup.TIMESPAN)) {
            viewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)"time.span.ns"));
        } else {
            viewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)DeviceDescriptionFactory.SCIENTIFIC_NOTATION));
        }
        this.m_refreshController.add((IRefreshable)viewer);
        this.hookModelDialViewer(viewer);
        return viewer;
    }

    private void hookModelDialViewer(final DialViewer viewer) {
        this.getBuilder().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Map values = (Map)DialComponent.this.getBuilder().getModel();
                for (Map.Entry entry : values.entrySet()) {
                    viewer.getDialProvider((String)entry.getKey());
                    viewer.setInput((String)entry.getKey(), entry.getValue());
                }
                DisplayToolkit.safeAsyncExec((Widget)viewer, (Runnable)new Runnable(){

                    public void run() {
                        viewer.refresh();
                    }
                });
            }
        });
    }

    private void addDials(DialViewer dialViewer, DialInformationViewer dialInformationViewer) {
        DialDescriptorRepository repository = this.getRepository();
        List<DialDescriptor> dials = repository.getDialDescriptors();
        int n = 0;
        while (n < dials.size()) {
            DialDescriptor dd = dials.get(n);
            if (dials.get(n).getAnimated()) {
                dialViewer.addDialProvider(Integer.toString(n), (IDialProvider)new MovingDial(dd.getColor()));
            } else {
                dialViewer.addDialProvider(Integer.toString(n), (IDialProvider)new FixedDial(dd.getColor()));
            }
            Field field = FieldFactory.createFromDisplayUnitWithIndexIdentifier((UnitDescriptor)repository.getUnit(), (String)dd.getAttributeIdentifier(), (int)n);
            field.setName(String.valueOf(dd.getName()) + ":");
            field.setDescription(dd.getDescription());
            dialInformationViewer.addDialInformationProvider(Integer.toString(n), (IDialInformationProvider)new DialFieldInformation(field));
            ++n;
        }
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    @Override
    public void operativeSetChange() {
    }
}

