/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.components.ui.base.AbstractViewerComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldViewerComparator;
import com.jrockit.mc.core.ui.fields.FieldViewerFilterControl;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.OperativeSetMenu;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnViewerComponent
extends AbstractViewerComponent
implements IOperativeSetAware {
    public static final String COLUMN_DESCRIPTOR_REPOSITORY = "columnDescriptorRepository";
    private FieldViewerFilterControl m_fieldViewerFilterControl;

    public Field[] createFields() {
        ColumnDescriptorRepository repository = this.getRepository();
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        for (ColumnDescriptor column : repository.getColumnDescriptors()) {
            fields.add(EventFieldToolkit.createField(column, String.valueOf(column.getAttributeIdentifier()) + index, index));
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            ViewModelBuilder builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            serviceLocator.registerService(ViewModelBuilder.class.getName(), (Object)builder);
            serviceLocator.registerService((Object)new OperativeSetService());
            return true;
        }
        return false;
    }

    protected abstract ViewModelBuilder createModelBuilder();

    protected final ViewModelBuilder getViewModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class);
    }

    public FieldViewerFilterControl getViewerFilterControl() {
        return this.m_fieldViewerFilterControl;
    }

    protected void initializeUI() {
        super.initializeUI();
        this.getMenuManager().add((IContributionItem)new OperativeSetMenu(this.getServiceLocator()));
        FieldViewerFilterControl fvfc = this.getViewerFilterControl();
        if (fvfc != null) {
            fvfc.initialize(this.getViewer(), this.getFields());
            fvfc.setFilteredField(this.getFields()[this.findFilteredColumnIndex()]);
        }
        this.updateSorting();
        EventTypeAcceptor eta = new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase());
        this.getModelBuilder().getView().setEventTypes(eta.getAcceptedSet());
    }

    protected void refresh() {
        this.getModelBuilder().scheduleRebuild();
    }

    protected final StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    protected final IEventTypeView createView() {
        return this.getRepository().getRole() == Role.SLAVE ? new SimpleView(new ArrayList<IEvent>()) : this.getFlightRecording().createView();
    }

    protected FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    protected final void updateSorting() {
        Field field;
        StructuredViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && (field = this.findSortedField()) != null) {
            viewer.setComparator((ViewerComparator)new FieldViewerComparator(viewer, field, field.getSortOrderAscending()));
        }
    }

    protected Composite createTopControl(Composite container) {
        if (this.isFilterable() || this.isOperativeSettable()) {
            Composite topControl = this.getFormToolkit().createComposite(container, 0);
            if (this.isFilterable()) {
                GridData gd1 = new GridData(4, 4, true, false);
                this.m_fieldViewerFilterControl = new FieldViewerFilterControl(topControl, this.getFormToolkit(), this.getFields().length > 1);
                this.m_fieldViewerFilterControl.setLayoutData((Object)gd1);
                this.m_fieldViewerFilterControl.addTraverseListener((TraverseListener)new SimpleTraverseListener());
                this.getFormToolkit().adapt((Composite)this.m_fieldViewerFilterControl);
            }
            if (this.isOperativeSettable()) {
                GridData gd2 = new GridData(4, 4, false, false);
                gd2.horizontalIndent = 5;
                Button checkBox = this.createOperativeSetButton(topControl);
                checkBox.setLayoutData((Object)gd2);
            }
            topControl.addTraverseListener((TraverseListener)new SimpleTraverseListener());
            topControl.setLayout(this.createTopControlLayout(topControl));
            this.getFormToolkit().adapt(topControl);
            return topControl;
        }
        return null;
    }

    private Layout createTopControlLayout(Composite topControl) {
        GridLayout layout = new GridLayout();
        layout.numColumns = topControl.getChildren().length;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected final Button createOperativeSetButton(Composite topControl) {
        final Button checkBox = this.getFormToolkit().createButton(topControl, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnViewerComponent.this.getModelBuilder().setOperativeSetEnabled(checkBox.getSelection());
                ColumnViewerComponent.this.getModelBuilder().scheduleRebuild();
            }
        });
        return checkBox;
    }

    protected final ViewModelBuilder getModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class);
    }

    protected final boolean isOperativeSettable() {
        return this.getRepository().getAllowOperativeSet();
    }

    protected boolean isFilterable() {
        return this.findFilteredColumnIndex() != -1;
    }

    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                return this.getFields()[index];
            }
            ++index;
        }
        return null;
    }

    private int findFilteredColumnIndex() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            if (column.getUseForFiltering()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected ColumnDescriptorRepository getRepository() {
        return (ColumnDescriptorRepository)this.getComponentSettings().getChildObject(COLUMN_DESCRIPTOR_REPOSITORY, ColumnDescriptorRepository.class);
    }

    protected boolean isOperativesetEnabled() {
        return this.getModelBuilder().getOperativeSetEnabled();
    }

    @Override
    public void operativeSetChange() {
        if (this.isOperativesetEnabled()) {
            this.markDirty();
        }
    }

    public void consumeEvents(Iterable<IEvent> events) {
        if (this.getRepository().getRole() == Role.SLAVE) {
            IEventTypeView oldView = this.getModelBuilder().getView();
            SimpleView newView = new SimpleView(events);
            newView.setRange(oldView.getRange());
            newView.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
            newView.setFilter(oldView.getFilter());
            this.getModelBuilder().setEventView(newView);
            this.markDirty();
        }
    }

    public void setTypeVisibilityChange(List<String> shown, List<String> hidden) {
        if (this.getRepository().getEventTypeDescriptorBase().getUserFilterConstrained()) {
            this.getModelBuilder().getView().setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
            this.markDirty();
        }
    }

    public void onChange(long startTime, long endTime) {
        IRange r = this.getModelBuilder().getView().getRange();
        if (r.getStartTimestamp() != startTime || r.getEndTimestamp() != endTime) {
            this.getModelBuilder().getView().setRange((IRange)new Range(startTime, endTime));
            this.markDirty();
        }
    }

    public boolean isTypeChangeEnabled() {
        return this.getRepository().getEventTypeDescriptorBase().getUserFilterConstrained();
    }
}

