/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IMasterDetailFactory;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnMasterDetailFactory
implements IMasterDetailFactory {
    private static Field[] FIELD_PROTYPES = new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    private final IServiceLocator m_locator;
    private final ColumnDescriptorRepository m_descriptorRepository;

    public ColumnMasterDetailFactory(ColumnDescriptorRepository descriptorRepository, IServiceLocator locator) {
        this.m_descriptorRepository = descriptorRepository;
        this.m_locator = locator;
    }

    protected final IServiceLocator getServiceLocator() {
        return this.m_locator;
    }

    protected final ColumnDescriptorRepository getRepository() {
        return this.m_descriptorRepository;
    }

    public final IInput createDetailBaseInput(Shell shell) {
        IInput eti = InputFactory.createEventTypeInput(this.m_locator);
        eti.addStatusListener(new IStatusListener(){

            public void onChange(IStatus status) {
            }
        });
        return eti;
    }

    private List<ColumnDescriptor> getColumns() {
        return this.m_descriptorRepository.getColumnDescriptors();
    }

    protected ColumnDescriptor createColumn(IRetriever retriver) {
        ColumnDescriptor column = new ColumnDescriptor();
        column.setName(retriver.getName());
        column.setDescription(retriver.getDescription());
        column.setVisible(true);
        column.setUnit(Toolkit.createUnit(retriver));
        column.setAttributeIdentifier(retriver.getAttributeIdentifier());
        return column;
    }

    public final List<Object> createDetailList() {
        return this.getColumns();
    }

    public final String createMasterTableTitle() {
        return Messages.COLUMN_CONFIGURATION_MASTER_DETAIL_TITLE;
    }

    public final List<Object> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.m_descriptorRepository.getEventTypeDescriptorBase();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.COLUMN_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.COLUMN_CONFIGURATION_MUST_SELECT_AT_LEAST_ONE_EVENT_TYPE_TEXT);
            return null;
        }
        BrowseForEventAttributeWizard bfew = new BrowseForEventAttributeWizard(this.m_locator, 2, false, this.m_descriptorRepository.getEventTypeDescriptorBase());
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfew);
        dialog.setWidthConstaint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            Object[] object = bfew.getSelection().toArray();
            ArrayList<Object> objects = new ArrayList<Object>();
            int n = 0;
            while (n < object.length) {
                objects.add(this.createColumn((IRetriever)object[n]));
                ++n;
            }
            return objects;
        }
        return null;
    }

    public final StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer m_tableViewer = new FieldTableViewer(table, FIELD_PROTYPES);
        m_tableViewer.setContentProvider((IContentProvider)new InformationContentProvider());
        m_tableViewer.setInput(this.getColumns());
        return m_tableViewer;
    }

    public List<IInput> createSpecific() {
        return new ArrayList<IInput>();
    }

    public String createSpecificTitle() {
        return null;
    }
}

