/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;

public final class ColumnDescriptor
extends InformationDescriptor {
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_WEIGHT = 100;
    private static final String VISIBLE = "visible";
    private static final String WEIGHT = "weight";
    private static final String MIN_WIDTH = "minimumWidth";
    private static final String PIE_CHART_BY = "pieChartBy";
    private static final String USE_FOR_FILTERING = "useForFiltering";
    private static final String SORTED = "sorted";
    private static final String NORMALIZE_DATA = "normalize";
    private static final String SORT_ASCENDING = "sortAscending";

    static {
        PersistenceToolkit.registerFetcher(ColumnDescriptor.class, (ISettingFetcher)new ISettingFetcher<ColumnDescriptor>(){

            public Setting getSetting(ColumnDescriptor column) {
                return column.m_setting;
            }
        });
    }

    public ColumnDescriptor() {
        super("columnDescriptor");
        this.setMinimumWidth(100);
        this.setWeight(100);
        this.setVisible(true);
        this.setAggregatorIdentifier(AggregatorFactory.getDefaultAggregatorDescriptor().getIdentifier());
    }

    public void setVisible(boolean visible) {
        this.m_setting.setChildObject(VISIBLE, (Object)visible);
    }

    public boolean isVisible() {
        return (Boolean)this.m_setting.getChildObject(VISIBLE, Boolean.class);
    }

    public void setWeight(int weight) {
        this.m_setting.setChildObject(WEIGHT, (Object)weight);
    }

    public int getWeight() {
        return (Integer)this.m_setting.getChildObject(WEIGHT, Integer.class);
    }

    public void setMinimumWidth(int minimumWidth) {
        this.m_setting.setChildObject(MIN_WIDTH, (Object)minimumWidth);
    }

    public int getMinimumWidth() {
        return (Integer)this.m_setting.getChildObject(MIN_WIDTH, Integer.class);
    }

    public void setPieChartBy(boolean pieChartBy) {
        this.m_setting.setChildObject(PIE_CHART_BY, (Object)pieChartBy);
    }

    public boolean isPieChartBy() {
        return (Boolean)this.m_setting.getChildObject(PIE_CHART_BY, Boolean.class);
    }

    public void setUseForFiltering(boolean use) {
        this.m_setting.setChildObject(USE_FOR_FILTERING, (Object)use);
    }

    public boolean getUseForFiltering() {
        return (Boolean)this.m_setting.getChildObject(USE_FOR_FILTERING, Boolean.class);
    }

    public void setNormalize(boolean normalize) {
        this.m_setting.setChildObject(NORMALIZE_DATA, (Object)normalize);
    }

    public boolean getNormalize() {
        return (Boolean)this.m_setting.getChildObject(NORMALIZE_DATA, Boolean.class);
    }

    public boolean isPreferredSortOrderAscending() {
        return (Boolean)this.m_setting.getChildObject(SORT_ASCENDING, Boolean.class);
    }

    public boolean isInitialSortColumn() {
        return (Boolean)this.m_setting.getChildObject(SORTED, Boolean.class);
    }
}

