/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDescriptorToolkit;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import java.util.Iterator;
import se.hirt.greychart.data.DefaultXYData;
import se.hirt.greychart.data.IXYData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FliteredFLRIterator
implements Iterator<IXYData> {
    private final Iterator<IEvent> m_iterator;
    private final String m_identifier;
    private IXYData<Long, Number> m_next;

    public FliteredFLRIterator(IEventTypeView view, DataSeriesDescriptor descriptor) {
        this.m_iterator = view.iterator();
        this.m_identifier = FLRDescriptorToolkit.getAttributeIdentifier(descriptor);
        this.skipForward();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public IXYData<Long, Number> next() {
        IXYData<Long, Number> next = this.m_next;
        this.skipForward();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove event");
    }

    private void skipForward() {
        while (this.m_iterator.hasNext()) {
            Number value;
            IEvent event = this.m_iterator.next();
            IEventType type = event.getEventType();
            IRetriever t = type.getRetriever(this.m_identifier);
            if (t == null || (value = (Number)t.getValue(event)) == null) continue;
            Long d = event.getEndTimestamp();
            this.m_next = new DefaultXYData((Object)d, (Object)value);
            return;
        }
        this.m_next = null;
    }
}

