/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.api.AndFilter;
import com.jrockit.mc.flightrecorder.api.EventOrder;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetFilterDescription;
import com.jrockit.mc.flightrecorder.ui.components.chart.ExpressionFilterFactory;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.chart.FliteredFLRIterator;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.NotOperativeSetFilter;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.OperativeSetFilter;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import java.util.Iterator;
import se.hirt.greychart.data.AbstractDataSeries;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.IXYData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FLRDataSeries
extends AbstractDataSeries
implements DataSeries {
    private final IServiceLocator m_serviceLocator;
    private final DataSeriesDescriptor m_dataseriesDescriptor;
    private final IEventTypeView m_eventTypeView;

    public FLRDataSeries(IServiceLocator locator, DataSeriesDescriptor descriptor, IEventTypeView view) {
        this.m_serviceLocator = locator;
        this.m_dataseriesDescriptor = descriptor;
        this.m_eventTypeView = view;
    }

    public Iterator<IXYData> createIterator(long min, long max) {
        this.m_eventTypeView.setRange(this.createRange(min, max));
        this.m_eventTypeView.setEventTypes(FLRDescriptorToolkit.createAcceptor(this.m_serviceLocator, this.m_dataseriesDescriptor).getAcceptedSet());
        this.m_eventTypeView.setExpansion(RangeSelection.EXPANDED);
        this.m_eventTypeView.setFilter(this.createFilter(this.m_dataseriesDescriptor));
        this.m_eventTypeView.setOrder(this.createOrder(this.m_dataseriesDescriptor));
        return new FliteredFLRIterator(this.m_eventTypeView, this.m_dataseriesDescriptor);
    }

    private IRange createRange(long min, long max) {
        if (FLRDescriptorToolkit.hasFilterExpression(this.m_dataseriesDescriptor)) {
            return IRange.INFINITE_RANGE;
        }
        return new Range(min, max);
    }

    private EventOrder createOrder(DataSeriesDescriptor descriptor) {
        if (descriptor.getStyle() == Style.DENSITY || descriptor.getStyle() == Style.DENSITY_INTEGRATING) {
            return EventOrder.DONT_CARE;
        }
        return EventOrder.ORDER_BY_TIME_ASCENDING;
    }

    private IRangeFilter createFilter(DataSeriesDescriptor descriptor) {
        IRangeFilter operativeSetFilter = this.createOperativeFilter(FLRDescriptorToolkit.getOperativeSet(descriptor));
        IRangeFilter valueExpressionFilter = ExpressionFilterFactory.createFilter(FLRDescriptorToolkit.getFilterExpression(descriptor));
        if (valueExpressionFilter != null) {
            if (operativeSetFilter == IRangeHolder.ALWAYS_TRUE_FILTER) {
                return valueExpressionFilter;
            }
            return new AndFilter(operativeSetFilter, valueExpressionFilter);
        }
        return operativeSetFilter;
    }

    private IRangeFilter createOperativeFilter(OperativeSetFilterDescription od) {
        if (od == OperativeSetFilterDescription.ONLY_NOT_OPERATIVE_SET) {
            return new NotOperativeSetFilter();
        }
        if (od == OperativeSetFilterDescription.ONLY_OPERATIVE_SET) {
            return new OperativeSetFilter();
        }
        return IRangeHolder.ALWAYS_TRUE_FILTER;
    }

    public boolean hasData() {
        return true;
    }
}

