/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.configuration.ChartMasterDetailFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FLRChartMasterDetailFactory
extends ChartMasterDetailFactory {
    private final IServiceLocator m_serviceLocator;

    protected FLRChartMasterDetailFactory(IServiceLocator locator, ChartDescriptor chartDescriptor, YAxisDescriptor axisDescriptor) {
        super(chartDescriptor, axisDescriptor);
        this.m_serviceLocator = locator;
    }

    protected List<IInput> createDataSourceInputs() {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        inputs.add(InputFactory.createEventTypeInput(this.m_serviceLocator));
        inputs.add(InputFactory.createAttributeWithDynamicRepository(this.m_serviceLocator, "eventTypes", false));
        inputs.add(InputFactory.createOperativeSet());
        return inputs;
    }

    public List<IInput> createMainInputs() {
        List inputs = super.createMainInputs();
        inputs.add(InputFactory.createRole(Role.INDEPENDENT));
        inputs.add(InputFactory.createOperativeSetEnabled());
        return inputs;
    }

    public IInput createDetailBaseInput(Shell shell) {
        return null;
    }

    public List<Object> createNew(Shell shell) {
        Object[] selectedObjects;
        BrowseForEventAttributeWizard wizardPage = new BrowseForEventAttributeWizard(this.m_serviceLocator, 2, false, null);
        wizardPage.setNumericAttributesOnly(true);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)wizardPage);
        dialog.setWidthConstaint(600, 800);
        dialog.setHeightConstraint(600, Integer.MAX_VALUE);
        if (dialog.open() == 0 && (selectedObjects = wizardPage.getSelection().toArray()).length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = 0;
            while (n < selectedObjects.length) {
                list.add(this.createDataSeriesDescriptor((IRetriever)selectedObjects[n]));
                ++n;
            }
            return list;
        }
        return new ArrayList<Object>();
    }

    private DataSeriesDescriptor createDataSeriesDescriptor(IRetriever retriever) {
        DataSeriesDescriptor dsd = new DataSeriesDescriptor();
        dsd.setName(retriever.getName());
        dsd.setDescription(retriever.getDescription());
        EventTypeDescriptorRepository etr = new EventTypeDescriptorRepository();
        EventTypeDescriptor etd = new EventTypeDescriptor();
        etd.setIdentifier(retriever.getEventTypePath());
        etd.setName(retriever.getEventTypePath());
        etr.getDescriptors().add(etd);
        FLRDescriptorToolkit.setEventTypeRepository(dsd, etr);
        FLRDescriptorToolkit.setAttributeIdentifier(dsd, retriever.getAttributeIdentifier());
        return dsd;
    }

    public List<IInput> createSpecific() {
        return null;
    }

    public String createSpecificTitle() {
        return null;
    }
}

