/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.ui.components.chart.ExpressionValueFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFilterFactory {
    public static IRangeFilter createFilter(String expression) {
        List<String> tokens = ExpressionFilterFactory.tokenize(expression);
        if (tokens.size() == 3 && "==".equals(tokens.get(1))) {
            return ExpressionFilterFactory.createEqualsFilter(tokens.get(0), tokens.get(2));
        }
        return null;
    }

    private static IRangeFilter createEqualsFilter(String attribute, String value) {
        if (value.startsWith("'") && value.endsWith("'") && value.length() >= 2) {
            return ExpressionFilterFactory.createStringEqualFilter(attribute, value);
        }
        return null;
    }

    private static IRangeFilter createStringEqualFilter(String attribute, String value) {
        final String compareString = value.substring(1, value.length() - 1);
        return new ExpressionValueFilter(attribute){

            protected boolean acceptValue(Object object) {
                return compareString.equals(object);
            }
        };
    }

    private static List<String> tokenize(String text) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inQuotes = false;
        String word = "";
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != ' ' || inQuotes) {
                if (c == '\'') {
                    inQuotes = !inQuotes;
                }
                word = String.valueOf(word) + c;
            } else {
                ExpressionFilterFactory.appendWord(list, word);
                word = "";
            }
            ++n2;
        }
        ExpressionFilterFactory.appendWord(list, word);
        return list;
    }

    private static void appendWord(List<String> list, String word) {
        if (word.length() != 0) {
            list.add(word);
        }
    }
}

