/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.behaviors.ICreateAccessiblePart;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.chart.FLRDataSeries;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.ITimestampedDataVisualizer;
import com.jrockit.mc.greychart.ui.views.accessability.AccessibleChartViewer;
import com.jrockit.mc.greychart.ui.views.chart.ChartViewer;
import com.jrockit.mc.greychart.ui.views.legend.LegendViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.SeriesProvider;
import se.hirt.greychart.impl.TimestampedDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChartComponent<XYData>
extends AbstractUIComponent
implements ICreateAccessiblePart,
INavigatorSelectionChangeListener {
    private static final int TABLE_IMAGE_SIZE = 10;
    private ITimestampedDataVisualizer m_visualizer;

    public Control createAccessiblePart(Composite parent) {
        this.m_visualizer = new AccessibleChartViewer(parent, this.getFormToolkit(), this.getChartDescriptor(), new SeriesProvider());
        return this.m_visualizer.getControl();
    }

    public Control createPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener(false));
        GridLayout layout = new GridLayout();
        container.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        GridData gd1 = new GridData(4, 4, true, false);
        LegendViewer legendViewer = this.createLegendViewer(container, this.getFormToolkit());
        legendViewer.getControl().setLayoutData((Object)gd1);
        GridData gd3 = new GridData(4, 4, true, true);
        this.m_visualizer = new ChartViewer(container, this.getFormToolkit(), this.getChartDescriptor(), (SeriesProvider)new TimestampedDataProvider());
        this.m_visualizer.getControl().setLayoutData((Object)gd3);
        container.setLayout((Layout)layout);
        return container;
    }

    @Override
    public void onChange(long startTime, long endTime) {
        if (this.m_visualizer != null) {
            this.m_visualizer.setRange(startTime, endTime);
            this.markDirty();
        }
    }

    private LegendViewer createLegendViewer(Composite parent, FormToolkit formToolkit) {
        LegendViewer viewer = new LegendViewer(parent, formToolkit, 256);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider(this.getChartDescriptor(), parent.getDisplay(), 10));
        viewer.setInput((Object)this.getChartDescriptor().getLegendDescriptors());
        return viewer;
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    protected void initializeUI() {
        super.initializeUI();
        this.m_visualizer.setRange(this.getStartService().getStartTimeStamp(), this.getStartService().getEndTimeStamp());
        this.fillProvider();
    }

    protected void refresh() {
        super.refresh();
        this.m_visualizer.refresh();
    }

    private void fillProvider() {
        SeriesProvider provider = this.m_visualizer.getDataProvider();
        for (DataSeriesDescriptor descriptor : this.getChartDescriptor().getDataSeriesDescriptors()) {
            provider.addDataSeries((DataSeries)new FLRDataSeries(this.getServiceLocator(), descriptor, ((FlightRecording)this.getServiceLocator().getService(FlightRecording.class)).createView()));
        }
        provider.fireDataChangeEvent(new DataChangeEvent((DataProvider)provider));
    }

    private ChartDescriptor getChartDescriptor() {
        return (ChartDescriptor)this.getComponentSettings().getChildObject("chartDescriptor", ChartDescriptor.class);
    }
}

