/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.aggregators;

import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorType;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;

public class Variance
implements IAggregator {
    private long n;
    private double mean;
    private double M2;

    public void add(Object value) {
        double x = ((Number)value).doubleValue();
        ++this.n;
        double delta = x - this.mean;
        this.mean += delta / (double)this.n;
        this.M2 += delta * (x - this.mean);
    }

    public AggregatorType getCompatibleWith() {
        return AggregatorType.NUMERIC;
    }

    public void addFromAggregator(IAggregator gator) {
        double deltaMean = ((Variance)gator).mean - this.mean;
        long ng = ((Variance)gator).n;
        this.mean += deltaMean * (double)(ng / (ng + this.n));
        this.M2 = ((Variance)gator).M2 + this.M2 + deltaMean * deltaMean * ((double)(ng * this.n) / (double)(this.n + ng));
        this.n += ng;
    }

    public Object getResult() {
        if (this.n == 0L) {
            return null;
        }
        return new Double(this.M2 / (double)(this.n - 1L));
    }
}

