/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.aggregators;

import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorType;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;

final class Average
implements IAggregator {
    private double result = 0.0;
    private long count = 0L;

    Average() {
    }

    public Object getResult() {
        if (this.count == 0L) {
            return null;
        }
        return new Double(this.result / (double)this.count);
    }

    public void add(Object value) {
        this.result += ((Number)value).doubleValue();
        ++this.count;
    }

    public AggregatorType getCompatibleWith() {
        return AggregatorType.NUMERIC;
    }

    public void addFromAggregator(IAggregator gator) {
        this.result += ((Average)gator).result;
        this.count += ((Average)gator).count;
    }
}

