/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.CheckedVisitor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventTypeAcceptor {
    private final Set<IEventType> m_acceptedEventTypeLookup;
    private final boolean m_userConstrained;

    public EventTypeAcceptor(IServiceLocator serviceLocator, EventTypeDescriptorRepository eventTypeRespoitory) {
        this(serviceLocator, eventTypeRespoitory, false);
    }

    public EventTypeAcceptor(IServiceLocator serviceLocator, EventTypeDescriptorRepository eventTypeRespoitory, boolean ignoreUserConstrained) {
        this.m_userConstrained = eventTypeRespoitory.getUserFilterConstrained() && !ignoreUserConstrained;
        this.m_acceptedEventTypeLookup = this.createAcceptedEventTypeLookup(serviceLocator, eventTypeRespoitory);
    }

    public boolean accept(IEventType type) {
        return this.m_acceptedEventTypeLookup.contains(type);
    }

    public Set<IEventType> getAcceptedSet() {
        return this.m_acceptedEventTypeLookup;
    }

    private boolean isUserConstrained() {
        return this.m_userConstrained;
    }

    private Set<IEventType> createAcceptedEventTypeLookup(IServiceLocator locator, EventTypeDescriptorRepository descriptorSet) {
        boolean userConstrained = this.isUserConstrained();
        LinkedHashSet<IEventType> set = new LinkedHashSet<IEventType>();
        Set<String> stuff = userConstrained ? this.createAcceptedPathsByUser(locator) : null;
        FlightRecording recording = (FlightRecording)locator.getService(FlightRecording.class);
        for (EventTypeDescriptor t : descriptorSet.getDescriptors()) {
            for (IEventType type : recording.getEventTypeRepository()) {
                if (!t.accepts(type.getPath())) continue;
                if (!userConstrained) {
                    set.add(type);
                    continue;
                }
                if (!stuff.contains(type.getPath())) continue;
                set.add(type);
            }
        }
        return set;
    }

    private Set<String> createAcceptedPathsByUser(IServiceLocator serviceLocator) {
        CheckedVisitor cv = new CheckedVisitor();
        ((TypeRespository)serviceLocator.getService(TypeRespository.class)).accept(cv);
        HashSet<String> set = new HashSet<String>();
        for (TypeDescriptor td : cv.getChecked()) {
            set.add(td.getPath());
        }
        return set;
    }
}

