/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.common;

import com.jrockit.mc.flightrecorder.api.EventOrder;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleView
implements IEventTypeView {
    private final Iterable<IEvent> m_events;
    private IRange m_range = new Range(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    private Set<IEventType> m_eventTypes = new HashSet<IEventType>();
    private IRangeFilter m_filter = IRangeHolder.ALWAYS_TRUE_FILTER;

    public SimpleView(Iterable<IEvent> events) {
        this.m_events = events;
    }

    public SimpleView() {
        this(new ArrayList<IEvent>());
    }

    public void setSpan(IRange range) {
        this.m_range = range;
    }

    public Iterator<IEvent> iterator() {
        return new InternalIterator();
    }

    public IRange getRange() {
        return this.m_range;
    }

    public void setRange(IRange range) {
        this.m_range = range;
    }

    public Collection<IEventType> getEventTypes() {
        return this.m_eventTypes;
    }

    public void setEventTypes(Collection<IEventType> types) {
        this.m_eventTypes = new HashSet<IEventType>(types);
    }

    public void setFilter(IRangeFilter filter) {
        this.m_filter = filter;
    }

    public IRangeFilter getFilter() {
        return this.m_filter;
    }

    public EventOrder getOrder() {
        throw new UnsupportedOperationException();
    }

    public void setOrder(EventOrder order) {
        throw new UnsupportedOperationException();
    }

    public void setExpansion(RangeSelection expanded) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<IEvent> {
        private IEvent m_event;
        private final Iterator<IEvent> m_it;
        final long start;
        final long end;

        InternalIterator() {
            this.start = SimpleView.this.m_range.getStartTimestamp();
            this.end = SimpleView.this.m_range.getEndTimestamp();
            this.m_it = SimpleView.this.m_events.iterator();
            this.skipForward();
        }

        @Override
        public boolean hasNext() {
            return this.m_event != null;
        }

        @Override
        public IEvent next() {
            if (this.m_event != null) {
                IEvent e = this.m_event;
                this.skipForward();
                return e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported by iterator");
        }

        public void skipForward() {
            while (this.m_it.hasNext()) {
                IEvent event = this.m_it.next();
                if (event.getStartTimestamp() < this.start || event.getStartTimestamp() > this.end || !SimpleView.this.m_eventTypes.contains(event.getEventType()) || !SimpleView.this.m_filter.accept((IRange)event)) continue;
                this.m_event = event;
                return;
            }
            this.m_event = null;
        }
    }
}

