/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.OperativeSetFilter;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.text.MessageFormat;
import java.util.Observable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewModelBuilder<T>
extends Observable {
    private static final IRangeFilter OPERATIVE_SET_FILTER = new OperativeSetFilter();
    private final IServiceLocator m_serviceLocator;
    private final String m_name;
    private volatile Job m_currentUpdateJob;
    private volatile T m_model;
    private volatile IEventTypeView m_eventView;
    private volatile String m_message;

    public ViewModelBuilder(IServiceLocator serviceLocator, ComponentDescriptor descriptor) {
        this.m_serviceLocator = serviceLocator;
        this.m_name = descriptor.getName();
    }

    public final void setEventView(IEventTypeView cloud) {
        this.m_eventView = cloud;
    }

    public final IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public final synchronized void scheduleRebuild() {
        if (this.m_eventView != null) {
            this.scheduleRebuild(this.m_eventView);
        }
    }

    public final synchronized void scheduleRebuild(IEventTypeView cloud) {
        if (this.m_currentUpdateJob != null) {
            this.m_currentUpdateJob.cancel();
        }
        class ViewUpdateJob
        extends Job {
            private final /* synthetic */ IEventTypeView val$cloud;

            public ViewUpdateJob(IEventTypeView iEventTypeView) {
                this.val$cloud = iEventTypeView;
                super(Messages.VIEWER_UPDATE_TEXT);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                ViewModelBuilder builder = ViewModelBuilder.this;
                monitor.beginTask(MessageFormat.format(Messages.VIEWER_UPDATE_FOR_TEXT, ViewModelBuilder.this.m_name), -1);
                builder.setLastBuildMessage(null);
                Object object = builder.buildModel(this.val$cloud, monitor);
                monitor.done();
                if (!monitor.isCanceled()) {
                    ViewModelBuilder viewModelBuilder = builder;
                    synchronized (viewModelBuilder) {
                        builder.m_model = object;
                        builder.setChanged();
                        ViewModelBuilder.this.m_currentUpdateJob = null;
                    }
                    builder.notifyObservers();
                    return StatusFactory.createOk((String)MessageFormat.format(Messages.VIEWER_UPDATE_COMPLETE_FOR_TEXT, ViewModelBuilder.this.getComponentName()));
                }
                return new Status(1, FlightRecorderUI.getDefault().getPluginName(), MessageFormat.format(Messages.VIEWER_UPDATE_ABORTED_FOR_TEXT, ViewModelBuilder.this.getComponentName()));
            }
        }
        this.m_currentUpdateJob = new ViewUpdateJob(cloud);
        this.m_currentUpdateJob.schedule();
    }

    protected final String getComponentName() {
        return this.m_name;
    }

    public final void stop() {
        if (this.m_currentUpdateJob != null) {
            this.m_currentUpdateJob.cancel();
        }
    }

    public final T getModel() {
        return this.m_model;
    }

    protected abstract T buildModel(IEventTypeView var1, IProgressMonitor var2);

    public IEventTypeView getView() {
        return this.m_eventView;
    }

    public void setOperativeSetEnabled(boolean enable) {
        if (enable) {
            this.m_eventView.setFilter(OPERATIVE_SET_FILTER);
        } else {
            this.m_eventView.setFilter((IRangeFilter)IRangeHolder.ALWAYS_TRUE_FILTER);
        }
    }

    public boolean getOperativeSetEnabled() {
        return this.m_eventView.getFilter() == OPERATIVE_SET_FILTER;
    }

    public String getLastBuildMessage() {
        return this.m_message;
    }

    public void setLastBuildMessage(String message) {
        this.m_message = message;
    }
}

