/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCPathEditorInput;
import com.jrockit.mc.core.idesupport.OpenHandler;
import com.jrockit.mc.core.misc.StatusFactory;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.PrintStreamProgressMonitor;
import com.jrockit.mc.flightrecorder.api.ProgressMonitor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.JRockitBinaryEventProvider;
import com.jrockit.mc.flightrecorder.spi.IEventProvider;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.filtering.FlightRecorderLoadWizardPage;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public final class FlightRecordingOpener
extends OpenHandler {
    private static final int MAXIMUM_FILE_SIZE = 1000000000;

    public void open(IWorkbenchWindow window, Object object) {
        if (object instanceof File) {
            this.openIfValidFile(window, (File)object);
        }
    }

    private void openIfValidFile(IWorkbenchWindow window, File file) {
        if (file.exists()) {
            this.openFile(window, file);
        } else {
            File absoluteFile = new File(CorePlugin.getDefault().getWorkspaceDirectory(), file.getPath());
            if (absoluteFile.exists()) {
                this.openFile(window, absoluteFile);
            } else {
                MessageDialog.openError((Shell)window.getShell(), (String)"Could not find file", (String)("Could not find file " + file.getPath()));
            }
        }
    }

    private void openFile(IWorkbenchWindow window, File file) {
        this.open(window, new MCPathEditorInput((IPath)new Path(file.getPath()), false));
    }

    private void open(IWorkbenchWindow window, MCPathEditorInput mpei) {
        IWorkbenchPage page = window.getActivePage();
        try {
            page.openEditor((IEditorInput)mpei, "flightRecordingEditor");
        }
        catch (PartInitException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not open Flight Recording", e);
        }
    }

    protected void openWithFiltering(final IWorkbenchWindow window, final File file) {
        final RecordingLoadJob lj = new RecordingLoadJob(file);
        lj.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FlightRecordingOpener.this.showFilterDialog(window, file, lj.getEventCount(), lj.getFlightRecording());
            }
        });
        lj.schedule();
    }

    protected boolean tooLarge(File file) {
        return file.length() > 1000000000L;
    }

    private void showFilterDialog(final IWorkbenchWindow window, final File file, final int eventCount, final FlightRecording recording) {
        DisplayToolkit.safeAsyncExec((Display)window.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                FlightRecorderLoadWizardPage w = new FlightRecorderLoadWizardPage(file, eventCount, recording);
                OnePageWizardDialog opw = new OnePageWizardDialog(window.getShell(), (IWizardPage)w);
                opw.setWidthConstaint(400, 600);
                opw.setHeightConstraint(300, 400);
                if (opw.open() == 0) {
                    MCPathEditorInput mpei = new MCPathEditorInput((IPath)new Path(file.getAbsolutePath()), false);
                    mpei.setUserData("startTime", "0");
                    mpei.setUserData("endTime", "0");
                    FlightRecordingOpener.this.open(window, mpei);
                }
            }
        });
    }

    static class RecordingLoadJob
    extends Job {
        private File m_file;
        private volatile FlightRecording recording;
        private int m_eventCount = 0;

        public RecordingLoadJob(File file) {
            super(Messages.FILE_OPENER_EXAMINING_LARGE_FILE_TEXT);
            this.m_file = file;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.recording = new FlightRecording();
            JRockitBinaryEventProvider jest = new JRockitBinaryEventProvider(this.m_file);
            jest.setProgressMonitor((ProgressMonitor)new PrintStreamProgressMonitor());
            this.recording.getConfiguration().setEventProvider((IEventProvider)jest);
            Iterator it = this.recording.iterator();
            while (it.hasNext()) {
                it.next();
                ++this.m_eventCount;
            }
            return StatusFactory.createOk((String)Messages.FILE_OPENER_RECORDING_EXAMINED_SUCCESSFULLY_TEXT);
        }

        int getEventCount() {
            return this.m_eventCount;
        }

        FlightRecording getFlightRecording() {
            return this.recording;
        }
    }
}

