/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.api.ProgressMonitor;
import com.jrockit.mc.flightrecorder.api.SilentProgressMonitor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.JRockitBinaryEventProvider;
import com.jrockit.mc.flightrecorder.spi.IEventProvider;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeRespository;
import java.io.File;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class FlightRecordingEditor
extends DesignEditor {
    public static final String EDITOR_ID = "flightRecordingEditor";

    public FlightRecordingEditor() {
        this.setNavigatorPosition("left");
        this.setTabPosition("bottom");
    }

    protected void initialize(IServiceLocator serviceLocator) throws PartInitException {
        UserInterfaceContribution container = (UserInterfaceContribution)serviceLocator.getService(UserInterfaceContribution.class);
        FormToolkit toolkit = new FormToolkit(ComponentsPlugin.getDefault().getFormColors(this.getSite().getShell().getDisplay()));
        serviceLocator.registerService((Object)container.getUserInterface());
        serviceLocator.registerService((Object)new UIScope(null));
        serviceLocator.registerService((Object)toolkit);
        IEditorInput validInput = this.getEditorInput();
        if (validInput instanceof IPathEditorInput) {
            IPathEditorInput ipei = (IPathEditorInput)validInput;
            FlightRecording recording = this.createRecording(ipei.getPath().toFile());
            serviceLocator.registerService((Object)recording);
            serviceLocator.registerService((Object)new StartService(recording));
            serviceLocator.registerService((Object)this.createTyperepository(recording));
            this.setPartName(ipei.getPath().toFile().getName());
        } else {
            this.setPartName(validInput.getName());
        }
        this.showView();
    }

    private void showView() {
        try {
            this.getSite().getWorkbenchWindow().getActivePage().showView("com.jrockit.mc.flightrecorder.ui.views.types.EventTypesView");
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    private TypeRespository createTyperepository(FlightRecording recording) {
        TypeRespository tr = new TypeRespository();
        for (IEventType type : recording.getEventTypeRepository()) {
            tr.addTypeDescriptor(this.createTypeDescriptor(type));
        }
        return tr;
    }

    private TypeDescriptor createTypeDescriptor(IEventType eventType) {
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        typeDescriptor.setName(eventType.getName());
        typeDescriptor.setDescription(eventType.getDescription());
        typeDescriptor.setChecked(this.isJava(eventType.getPath()));
        typeDescriptor.setColor(new MCColor(eventType.getColor()));
        typeDescriptor.setPath(eventType.getPath());
        typeDescriptor.setDiscovered(true);
        return typeDescriptor;
    }

    private boolean isJava(String path) {
        return path != null && path.startsWith("java") && !path.startsWith("java/statistics");
    }

    private FlightRecording createRecording(File file) {
        FlightRecording recording = new FlightRecording();
        JRockitBinaryEventProvider eventProvider = new JRockitBinaryEventProvider(file);
        eventProvider.setProgressMonitor((ProgressMonitor)new SilentProgressMonitor());
        recording.getConfiguration().setEventProvider((IEventProvider)eventProvider);
        return recording;
    }

    public void dispose() {
        FlightRecording flr = (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
        flr.flush();
        super.dispose();
    }
}

