/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.value;

import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveValue
implements IValue {
    private static final Class<?>[][] TYPES = new Class[][]{{Boolean.class, Boolean.TYPE}, {Byte.class, Byte.TYPE}, {Short.class, Short.TYPE}, {Character.class, Character.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Float.class, Float.TYPE}, {Double.class, Double.TYPE}};
    private final Object primitiveValue;

    public PrimitiveValue(Object valueWrapper) {
        this.primitiveValue = valueWrapper;
    }

    public static Class<?> getPrimitiveType(Class<?> wrapper) {
        Class<?> result = null;
        int i = 0;
        while (i < TYPES.length) {
            if (wrapper.equals(TYPES[i][0])) {
                result = TYPES[i][1];
                break;
            }
            ++i;
        }
        return result != null ? result : wrapper;
    }

    @Override
    public final boolean isPrimitive() {
        return true;
    }

    @Override
    public Object getPrimitiveValue() {
        return this.primitiveValue;
    }

    @Override
    public final IObjectInfo getReference() {
        return null;
    }

    @Override
    public boolean isNonNullObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public String toString() {
        return "Value[value=" + this.primitiveValue + ", primitiveType=" + this.primitiveValue.getClass().getName() + ']';
    }
}

