/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.value;

import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.ILocation;
import com.jrockit.memleak.IMethodInfo;
import com.jrockit.memleak.util.IClassInfoHolder;

public class Location
implements ILocation,
IClassInfoHolder {
    private final IMethodInfo methodInfo;
    private final int line;

    public Location(IMethodInfo methodInfo, int line) {
        this.methodInfo = methodInfo;
        this.line = line;
    }

    public IMethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public IClassInfo getClassInfo() {
        return this.methodInfo.getDeclaringClassInfo();
    }

    public int getLine() {
        return this.line;
    }

    public boolean isNative() {
        return this.line == -2;
    }

    public String toString() {
        return String.valueOf(this.methodInfo.toString()) + '(' + this.methodInfo.getDeclaringClassInfo().getSourceFileName() + ':' + this.line + ')';
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof ILocation) {
            ILocation other = (ILocation)that;
            return this.methodInfo.equals(other.getMethodInfo()) && this.line == other.getLine();
        }
        return false;
    }

    public int hashCode() {
        return this.methodInfo.hashCode() * 31 + this.line;
    }
}

