/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.value;

import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.util.IModifyOnce;
import com.jrockit.memleak.util.ValueProperty;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
implements IClassInfo,
IObjectSpecifier,
IModifyOnce {
    private final int classID;
    private final String name;
    private int modifiers;
    protected String srcFileName;
    private IObjectSpecifier classLoaderSpec;
    private int numDeclaredStaticFields = -1;
    private int numInstanceFields = -1;

    public ClassInfo(int classID, String name, int modifiers, int numDeclaredStaticFields, int numInstanceFields, String srcFileName, IObjectSpecifier classLoaderSpec) {
        assert (classID != -2);
        this.classID = classID;
        this.name = name;
        this.modifiers = modifiers;
        this.numDeclaredStaticFields = numDeclaredStaticFields;
        this.numInstanceFields = numInstanceFields;
        this.srcFileName = srcFileName;
        this.classLoaderSpec = classLoaderSpec;
    }

    @Override
    public int getClassId() {
        return this.classID;
    }

    @Override
    public IObjectSpecifier getClassLoaderSpec() {
        return this.classLoaderSpec;
    }

    @Override
    public IObjectSpecifier getClassObjectSpec() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isArrayClass() {
        return this.name.charAt(0) == '[';
    }

    public int hashCode() {
        return this.classID;
    }

    public boolean equals(Object other) {
        return other instanceof IClassInfo && this.equals((IClassInfo)other);
    }

    private boolean equals(IClassInfo other) {
        return this == other || this.classID == other.getClassId() && this.name.equals(other.getName());
    }

    @Override
    public <T> T select(ITypeResolver<T> resolver) {
        if (this.classID != -1) {
            return resolver.withClassNameAndIDs(this.name, this.classID);
        }
        return resolver.withClassName(this.name);
    }

    public String toString() {
        return "ClassInfo[id=" + this.classID + ", name=" + this.name + ", loader=" + this.classLoaderSpec + ", modifiers=" + Modifier.toString(this.modifiers) + ", src=" + this.srcFileName + ']';
    }

    @Override
    public int getObjectId() {
        return this.classID;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getSourceFileName() {
        return this.srcFileName;
    }

    @Override
    public int getNumDeclaredStaticFields() {
        return this.numDeclaredStaticFields;
    }

    @Override
    public int getNumInstanceFields() {
        return this.numInstanceFields;
    }

    @Override
    public boolean overrideDefault(ValueProperty property, Object value) throws ClassCastException {
        Integer currentValue;
        switch (property) {
            case NUM_DECLARED_STATIC_FIELDS: {
                currentValue = this.numDeclaredStaticFields;
                break;
            }
            case NUM_INSTANCE_FIELDS: {
                currentValue = this.numInstanceFields;
                break;
            }
            default: {
                return false;
            }
        }
        if (!property.isAcceptable(currentValue, value)) {
            return false;
        }
        switch (property) {
            case NUM_DECLARED_STATIC_FIELDS: {
                this.numDeclaredStaticFields = (Integer)value;
                break;
            }
            case NUM_INSTANCE_FIELDS: {
                this.numInstanceFields = (Integer)value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

