/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.util;

import com.jrockit.memleak.INamedType;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.util.TypeResolverAdapter;

public class TypeSpecifierHelper {
    private static final HumanTypeResolver HR = new HumanTypeResolver();

    public static String describe(ITypeSpecifier specifier) {
        return specifier.select(HR);
    }

    public static String fieldDescToBinaryJLS(String descriptor) {
        boolean isPrimitive = false;
        String typeName = descriptor.replace('/', '.');
        if (typeName.startsWith("[")) {
            if (typeName.startsWith("[L")) {
                typeName = String.valueOf(typeName.substring(2)) + "[]";
                typeName = typeName.replaceAll(";", "");
            } else {
                if ((typeName = String.valueOf(typeName.substring(1)) + "[]").startsWith("[")) {
                    return TypeSpecifierHelper.fieldDescToBinaryJLS(typeName);
                }
                isPrimitive = true;
            }
            if (isPrimitive) {
                switch (typeName.charAt(0)) {
                    case 'Z': {
                        typeName = typeName.replaceFirst("Z", "boolean");
                        break;
                    }
                    case 'B': {
                        typeName = typeName.replaceFirst("B", "byte");
                        break;
                    }
                    case 'S': {
                        typeName = typeName.replaceFirst("S", "short");
                        break;
                    }
                    case 'C': {
                        typeName = typeName.replaceFirst("C", "char");
                        break;
                    }
                    case 'I': {
                        typeName = typeName.replaceFirst("I", "int");
                        break;
                    }
                    case 'J': {
                        typeName = typeName.replaceFirst("J", "long");
                        break;
                    }
                    case 'F': {
                        typeName = typeName.replaceFirst("F", "float");
                        break;
                    }
                    case 'D': {
                        typeName = typeName.replaceFirst("D", "double");
                        break;
                    }
                    default: {
                        System.err.println("Error in converting" + descriptor + " to type name.");
                    }
                }
            }
        }
        return typeName;
    }

    public static boolean isArrayType(INamedType type) {
        return type.getName().startsWith("[");
    }

    public static int getDisplayId(int fullID) {
        return fullID & 0xFFFFFFF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HumanTypeResolver
    extends TypeResolverAdapter<String> {
        private HumanTypeResolver() {
        }

        @Override
        public String withClassName(String className) {
            return "Types with class name " + className + '.';
        }

        @Override
        public String withClassID(int id) {
            return "Types with class ID " + id + '.';
        }
    }
}

