/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.util;

import com.jrockit.memleak.INamedType;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.util.TypeSpecifierHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeName
implements INamedType {
    public static final INamedType OBJECT = TypeName.get(Object.class);
    public static final INamedType STRING = TypeName.get(String.class);
    public static final INamedType CLASS = new TypeName("java/lang/Class");
    private final String name;
    private TypeName array;

    public static TypeName get(String name) {
        return new TypeName(name);
    }

    public static INamedType get(Class<?> type) {
        if (type.isPrimitive()) {
            return null;
        }
        String name = type.getName().replace('.', '/');
        return new TypeName(name);
    }

    public TypeName(String name) {
        this.name = name;
    }

    @Override
    public <T> T select(ITypeResolver<T> resolver) {
        return resolver.withClassName(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TypeName array() {
        if (this.array == null) {
            this.array = this.name.charAt(0) == '[' ? new TypeName(String.valueOf('[') + this.name) : new TypeName("[L" + this.name + ";");
        }
        return this.array;
    }

    public String toString() {
        return TypeSpecifierHelper.describe(this);
    }
}

