/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.util;

import com.jrockit.memleak.AllocTraceCallback;
import com.jrockit.memleak.DisconnectCallback;
import com.jrockit.memleak.Feature;
import com.jrockit.memleak.IArraySizeInfo;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IClassRef;
import com.jrockit.memleak.IFieldValue;
import com.jrockit.memleak.IHeapHistogram;
import com.jrockit.memleak.IInstanceReferrers;
import com.jrockit.memleak.IMemLeak;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.IPointToTypeInfo;
import com.jrockit.memleak.IRelationshipInfo;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.ITypeHeapInfo;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.IValue;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NotAnArrayException;
import com.jrockit.memleak.TrendAnalysisCallback;
import com.jrockit.memleak.util.TypeName;
import com.jrockit.memleak.value.KnownTruncatable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemLeakAdapter
implements IMemLeak {
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected Map<Object, Object> metaData = new HashMap<Object, Object>();

    @Override
    public void deleteObjectId(IObjectSpecifier objectSpec) throws IOException, MemLeakServerException {
        this.deleteObjectId(objectSpec.getObjectId());
    }

    @Override
    public void deleteObjectId(int objectId) throws IOException, MemLeakServerException {
    }

    @Override
    public void deleteObjectIds(int ... objectIds) throws IOException, MemLeakServerException {
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int objectId = nArray[n2];
            this.deleteObjectId(objectId);
            ++n2;
        }
    }

    @Override
    public void deleteAllObjectIds() throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() throws IOException {
    }

    @Override
    public void disableAllocTraces() throws IOException, MemLeakServerException {
    }

    @Override
    public void doFullGC() throws IOException, MemLeakServerException {
    }

    @Override
    public final void enableAllocTracesForClass(String type, int bufferSize, int interval, AllocTraceCallback callback) throws IOException, IllegalStateException, MemLeakServerException {
        this.enableAllocTracesForClass(TypeName.get(type), bufferSize, interval, callback);
    }

    @Override
    public void enableAllocTracesForClass(ITypeSpecifier type, int bufferSize, int interval, AllocTraceCallback callback) throws IOException, IllegalStateException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAllocTraceFrequency() throws IOException, MemLeakServerException {
        return 1;
    }

    @Override
    public IValue[] getArrayData(IObjectSpecifier objectSpec, int from, int len) throws IOException, IllegalArgumentException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArrayLength(IObjectSpecifier objectSpec) throws IOException, IllegalArgumentException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldValue[] getFieldValues(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, IllegalArgumentException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldValue[] getStaticFields(IClassRef classRef) throws IOException, IllegalArgumentException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IHeapHistogram getHeapHistogram() throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getHistogramCutoff() {
        return 0.0;
    }

    @Override
    public final ITruncatable<IRelationshipInfo> getInstanceRelationships(String fromType, String toType, int maxRelations, long stopAt, int maxMillis) throws IOException, MemLeakServerException {
        return this.getInstanceRelationships(TypeName.get(fromType), TypeName.get(toType), maxRelations, stopAt, maxMillis);
    }

    @Override
    public ITruncatable<IRelationshipInfo> getInstanceRelationships(ITypeSpecifier fromType, ITypeSpecifier toType, int maxRelations, long stopAt, int maxMillis) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IInstanceReferrers getInstancesPointingTo(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITruncatable<IInstanceReferrers> getPathPointingTo(IObjectSpecifier objectSpec, int maxDepth, int maxMillis) throws IOException, MemLeakServerException {
        return new KnownTruncatable<IInstanceReferrers>(IInstanceReferrers.EMPTY_ARRAY);
    }

    @Override
    public long getKeepAliveSizeOf(IObjectSpecifier objectSpec, long stopAt, long oldestAcceptable) throws IOException, MemLeakServerException {
        return 0L;
    }

    @Override
    public final ITruncatable<IArraySizeInfo> getLargestArrays(String type) throws IOException, MemLeakServerException, NotAnArrayException {
        return this.getLargestArrays(TypeName.get(type));
    }

    @Override
    public ITruncatable<IArraySizeInfo> getLargestArrays(ITypeSpecifier type) throws IOException, MemLeakServerException, NotAnArrayException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getMetaData(Object key) {
        if ("KNOWN_KEYS".equals(key)) {
            return this.metaData.keySet();
        }
        return this.metaData.get(key);
    }

    @Override
    public Set<Feature> getFeatures() {
        return Collections.emptySet();
    }

    @Override
    public boolean hasFeatures(Feature ... features) {
        Set<Feature> onFeatures = this.getFeatures();
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature = featureArray[n2];
            if (!onFeatures.contains((Object)feature)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public final IPointToTypeInfo[] getTypesPointingTo(String type, long oldestAcceptable) throws IOException, MemLeakServerException {
        return this.getTypesPointingTo(TypeName.get(type), Long.MAX_VALUE);
    }

    @Override
    public IPointToTypeInfo[] getTypesPointingTo(ITypeSpecifier type, long oldestAcceptable) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAllocTracesEnabled() throws IOException, MemLeakServerException {
        return false;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isTrendAnalysisEnabled() throws IOException, MemLeakServerException {
        return false;
    }

    @Override
    public void pollAllocationTraces() throws IOException, IllegalStateException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAllocTraceFrequency(int reportInterval) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisconnectCallback(DisconnectCallback disconnectCallback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFactory(IMemleakValueFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHistogramCutoff(double histogramCutoff) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTrendAnalysisCallback(TrendAnalysisCallback cb) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTrendAnalysisEnabled(boolean enabled) throws IOException, IllegalStateException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObjectInfo getObjectInfo(IObjectSpecifier objectSpec) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IClassInfo getClassInfo(IClassRef classRef) throws IOException, MemLeakServerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final IClassRef[] getClasses(String className, long oldestAcceptable) throws IOException, MemLeakServerException {
        return this.getClasses(TypeName.get(className), Long.MAX_VALUE);
    }

    @Override
    public IClassRef[] getClasses(ITypeSpecifier type, long oldestAcceptable) throws IOException, MemLeakServerException {
        return IClassRef.EMPTY_ARRAY;
    }

    @Override
    public ITruncatable<IObjectInfo> getInstances(IClassRef classRef, int maxInstances) throws IOException, MemLeakServerException {
        return new KnownTruncatable<IObjectInfo>(IObjectInfo.EMPTY_ARRAY);
    }

    @Override
    public ITypeHeapInfo<IClassInfo> getLastTypeHeapInfo(IClassInfo classInfo, long oldestAcceptable) {
        return null;
    }

    @Override
    public ITypeHeapInfo<?> getLastTypeHeapInfo(String refType, long oldestAcceptable) {
        return null;
    }
}

