/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.GarbageCollectedException;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NoSuchIdException;
import com.jrockit.memleak.NotAClassException;
import com.jrockit.memleak.NotAnArrayException;
import com.jrockit.memleak.TimedOutException;
import com.jrockit.memleak.TooComplexException;
import com.jrockit.memleak.mlp.MlpErr;
import com.jrockit.memleak.mlp.RequestType;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

class ServerResponse {
    private static final int FLAG_ASYNCH = 1;
    private static final int FLAG_TIMED_OUT = 2;
    private static final int FLAG_LIMITED_COMPLEXITY = 4;
    private static final int FLAG_LIMITED_ELEMENTS = 8;
    private RequestType requestType;
    private byte[] data;
    private MlpErr mlpError;
    private int flags;
    private int id;

    ServerResponse(RequestType type, MlpErr mlpError, int flags, int id, byte[] data) {
        assert (type != null);
        this.requestType = type;
        this.flags = flags;
        this.id = id;
        assert (data != null) : "RequestType=" + (Object)((Object)type) + ", flags=" + flags;
        this.data = data;
        assert (mlpError != null) : "RequestType=" + (Object)((Object)type) + ", flags=" + flags;
        this.mlpError = mlpError;
    }

    DataInputStream createDataInputStream() throws IOException, MemLeakServerException {
        this.throwAnyError();
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    void throwAnyError() throws IOException, MemLeakServerException {
        if (this.isServerError()) {
            String msg = this.getServerErrorMessage();
            switch (this.mlpError) {
                case END_OF_PACKET: {
                    throw new EOFException("On server: " + msg);
                }
                case REQ_UNSUPPORTED: {
                    throw new UnsupportedOperationException(msg);
                }
                case ID_UNUSED: {
                    throw new NoSuchIdException(msg);
                }
                case ID_DISCARDED: {
                    throw new GarbageCollectedException(msg);
                }
                case ID_NOT_CLASS: {
                    throw new NotAClassException(msg);
                }
                case ID_NOT_ARRAY: {
                    throw new NotAnArrayException(msg);
                }
                case INDEX_OUT_OF_BOUNDS: {
                    throw new ArrayIndexOutOfBoundsException(msg);
                }
                case TIMED_OUT: {
                    throw new TimedOutException(msg);
                }
                case TOO_COMPLEX: {
                    throw new TooComplexException(msg);
                }
            }
            throw new MemLeakServerException(msg);
        }
    }

    RequestType getType() {
        return this.requestType;
    }

    boolean isAsync() {
        return (this.flags & 1) != 0;
    }

    ITruncatable.Reason getFlagsAsReason() {
        int lowFlag = Integer.lowestOneBit(this.flags & 0xFFFFFFFE);
        switch (lowFlag) {
            case 2: {
                return ITruncatable.Reason.TIMEOUT;
            }
            case 4: {
                return ITruncatable.Reason.COMPLEXITY_LIMIT;
            }
            case 8: {
                return ITruncatable.Reason.ELEMENT_LIMIT;
            }
        }
        return null;
    }

    int getId() {
        return this.id;
    }

    boolean isServerError() {
        return this.mlpError != MlpErr.NONE;
    }

    MlpErr getServerError() {
        return this.mlpError;
    }

    String getServerErrorMessage() {
        if (this.isServerError()) {
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data));
                return dis.readUTF();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

