/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.mlp.MlpVerbosity;
import com.jrockit.memleak.mlp.RequestType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ServerRequest {
    private static int NEXT_ID = 1;
    private static Object NEXT_ID_LOCK = new Object();
    private int id;
    private RequestType requestType;
    private DataOutputStream dos;
    private ByteArrayOutputStream baos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerRequest(RequestType requestType) {
        this.requestType = requestType;
        Object object = NEXT_ID_LOCK;
        synchronized (object) {
            this.id = NEXT_ID++;
        }
        this.baos = new ByteArrayOutputStream(100);
        this.dos = new DataOutputStream(this.baos);
    }

    void addArgument(String string) throws IOException {
        this.dos.writeUTF(string);
    }

    void addArgument(IObjectSpecifier objectSpec) throws IOException {
        this.addArgument(objectSpec.getObjectId());
    }

    void addArgument(MlpVerbosity verbosity) throws IOException {
        this.addArgument(verbosity != null ? verbosity.ordinal() : -1);
    }

    void addVerbosity(MlpVerbosity objects, MlpVerbosity classes, MlpVerbosity classLoaders) throws IOException {
        this.addArgument(objects);
        this.addArgument(classes);
        this.addArgument(classLoaders);
    }

    void addArgument(int i) throws IOException {
        this.dos.writeInt(i);
    }

    void addArgument(long l) throws IOException {
        this.dos.writeLong(l);
    }

    void addArgument(boolean b) throws IOException {
        this.dos.writeBoolean(b);
    }

    byte[] getRequestData() {
        return this.baos.toByteArray();
    }

    RequestType getType() {
        return this.requestType;
    }

    int getId() {
        return this.id;
    }
}

