/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.mlp.InfoCachingFactory;
import com.jrockit.memleak.util.DelegatingValueFactory;
import com.jrockit.memleak.value.ClassInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class NameMappingCacheFactory
extends InfoCachingFactory {
    private Map<String, Integer> refTypeToID = new HashMap<String, Integer>();
    private AtomicInteger nextTypeID = new AtomicInteger(0);
    private IObjectSpecifier defaultClassLoader;

    public NameMappingCacheFactory(IMemleakValueFactory delegate, IObjectSpecifier classLoader) {
        super(new FactoryWrapper(delegate));
        this.defaultClassLoader = classLoader;
    }

    public IClassInfo getClassInfo(String refType) {
        Integer existingID = this.refTypeToID.get(refType);
        if (existingID != null) {
            IClassInfo info = this.getClassInfo(existingID);
            assert (info != null);
            return info;
        }
        return null;
    }

    public ClassInfoR26 getOrCreateClassInfo(String refType) {
        Integer existingID = this.refTypeToID.get(refType);
        if (existingID != null) {
            IClassInfo info = this.getClassInfo(existingID);
            assert (info != null) : String.valueOf(refType) + '<' + existingID + '>';
            return (ClassInfoR26)info;
        }
        return this.createClassInfo(this.nextTypeID.getAndIncrement(), refType, 18183, -1, -1, null, this.defaultClassLoader);
    }

    public synchronized ClassInfoR26 createClassInfo(int classID, String refType, int modifiers, int numDeclaredStaticFields, int numInstanceFields, String srcFileName, IObjectSpecifier classLoaderSpec) {
        ClassInfoR26 info = (ClassInfoR26)super.createClassInfo(classID, refType, modifiers, numDeclaredStaticFields, numInstanceFields, srcFileName, classLoaderSpec);
        Integer existingID = this.refTypeToID.get(refType);
        if (existingID == null) {
            this.refTypeToID.put(refType, classID);
        } else assert (existingID == classID);
        return info;
    }

    public synchronized void clearClasses(int ... classIDs) {
        int[] nArray = classIDs;
        int n = classIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            IClassInfo info = this.getClassInfo(id);
            if (info != null) {
                this.refTypeToID.remove(info.getName());
            }
            ++n2;
        }
        super.clearClasses(classIDs);
    }

    public static class ClassInfoR26
    extends ClassInfo {
        private IObjectSpecifier classObjectSpec;

        public ClassInfoR26(int classID, String name, int modifiers, int numDeclaredStaticFields, int numInstanceFields, String srcFileName, IObjectSpecifier classLoaderSpec) {
            super(classID, name, modifiers, numDeclaredStaticFields, numInstanceFields, srcFileName, classLoaderSpec);
        }

        public void setClassObjectSpec(IObjectSpecifier classObjectSpec) {
            this.classObjectSpec = classObjectSpec;
        }

        public void setSourceFileName(String srcFileName) {
            this.srcFileName = srcFileName;
        }

        public IObjectSpecifier getClassObjectSpec() {
            return this.classObjectSpec;
        }
    }

    private static class FactoryWrapper
    extends DelegatingValueFactory {
        public FactoryWrapper(IMemleakValueFactory delegate) {
            super(delegate);
        }

        public IClassInfo createClassInfo(int classID, String name, int modifiers, int numDeclaredStaticFields, int numInstanceFields, String srcFileName, IObjectSpecifier classLoaderSpec) {
            return new ClassInfoR26(classID, name, modifiers, numDeclaredStaticFields, numInstanceFields, srcFileName, classLoaderSpec);
        }
    }
}

