/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MlpUtil {
    public static BitSet readBitSet(DataInputStream in, int byteCount) throws IOException {
        BitSet bits = new BitSet(byteCount * 8);
        int i = 0;
        while (i < byteCount) {
            byte octet = in.readByte();
            int bit = 0;
            while (bit < 8) {
                if ((octet & 1 << bit) != 0) {
                    bits.set((i << 3) + bit);
                }
                ++bit;
            }
            ++i;
        }
        return bits;
    }

    public static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> enumType, BitSet bits) {
        Enum[] universe = (Enum[])enumType.getEnumConstants();
        EnumSet<Enum> enums = EnumSet.noneOf(enumType);
        int i = 0;
        while (i < universe.length) {
            if (bits.get(i)) {
                enums.add(universe[i]);
            }
            ++i;
        }
        return enums;
    }

    public static <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumType, DataInputStream in, int byteCount) throws IOException {
        return MlpUtil.toEnumSet(enumType, MlpUtil.readBitSet(in, byteCount));
    }

    public static Logger logger() {
        return Logger.getLogger("com.jrockit.memleak.mlp");
    }

    public static void log(Exception e) {
        MlpUtil.logger().log(Level.WARNING, e.getMessage(), e);
    }
}

