/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.Feature;
import com.jrockit.memleak.GarbageCollectedException;
import com.jrockit.memleak.IArrayInfo;
import com.jrockit.memleak.IArraySizeInfo;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IClassRef;
import com.jrockit.memleak.IFieldInfo;
import com.jrockit.memleak.IFieldValue;
import com.jrockit.memleak.IInstanceReferrers;
import com.jrockit.memleak.ILocation;
import com.jrockit.memleak.IMethodInfo;
import com.jrockit.memleak.INamedType;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.IRelationshipInfo;
import com.jrockit.memleak.IStaticField;
import com.jrockit.memleak.IThreadRoot;
import com.jrockit.memleak.ITrace;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.IValue;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NotAnArrayException;
import com.jrockit.memleak.mlp.AbstractMemLeak;
import com.jrockit.memleak.mlp.CommunicationChannel;
import com.jrockit.memleak.mlp.MlpUtil;
import com.jrockit.memleak.mlp.MlpVerbosity;
import com.jrockit.memleak.mlp.RequestType;
import com.jrockit.memleak.mlp.ServerRequest;
import com.jrockit.memleak.mlp.ServerResponse;
import com.jrockit.memleak.util.IInfoCacheControl;
import com.jrockit.memleak.util.TypeSpecifierHelper;
import com.jrockit.memleak.value.KnownTruncatable;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemLeakR28
extends AbstractMemLeak {
    private static final int MAJOR_MLP_VERSION = 3;
    private static final int MINOR_DEV_MLP_VERSION = 17;
    private IClassInfo jlcClassInfo;
    private int[] requestRevisions;
    private final ClassIdResolver resolver = new ClassIdResolver();

    protected static boolean supportsMlpVersion(int major, int minor) {
        return major == 3 && minor == 17;
    }

    public MemLeakR28(CommunicationChannel channel, int port) {
        super(channel, port);
        this.classInfoResolver = new ClassInfoResolver();
        this.enabledRequests = null;
        if (!this.setVerboseMLP(MlpVerbosity.NEW, MlpVerbosity.NEW, MlpVerbosity.NEW)) {
            System.err.println("Verbosity failed");
        }
        this.jlcClassInfo = this.findJavaLangClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IClassInfo findJavaLangClass() {
        IInfoCacheControl iInfoCacheControl = this.infoCache;
        synchronized (iInfoCacheControl) {
            if (this.jlcClassInfo == null) {
                IClassInfo candidate = null;
                ServerRequest req = new ServerRequest(RequestType.REQ_GET_CLASSES);
                try {
                    req.addArgument("java/lang/Class");
                    req.addVerbosity(MlpVerbosity.NEW, MlpVerbosity.ALL, MlpVerbosity.NEW);
                    ServerResponse resp = this.channel.postRequestAndWait(req);
                    DataInputStream dis = resp.createDataInputStream();
                    int n = dis.readInt();
                    if (n != 1) {
                        System.err.println("Warning: Found " + n + " classes named " + "java/lang/Class" + '!');
                    }
                    int i = 0;
                    while (i < n) {
                        candidate = (IClassInfo)this.parseClass(dis, false);
                        if (candidate.getClassLoaderSpec() == null) {
                            this.jlcClassInfo = candidate;
                            return this.jlcClassInfo;
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MemLeakServerException e) {
                    e.printStackTrace();
                }
                System.err.println("Error: Found no java/lang/Class class loaded by the bootstrap class loader!");
                this.jlcClassInfo = candidate;
            }
            return this.jlcClassInfo;
        }
    }

    public boolean setVerboseMLP(MlpVerbosity objects, MlpVerbosity classes, MlpVerbosity classLoaders) {
        block5: {
            DataInputStream dis;
            block7: {
                block6: {
                    if (!this.supportsRequest(RequestType.REQ_SET_AND_GET_PROTOCOL_VERBOSITY)) break block5;
                    ServerRequest req = new ServerRequest(RequestType.REQ_SET_AND_GET_PROTOCOL_VERBOSITY);
                    req.addVerbosity(objects, classes, classLoaders);
                    ServerResponse resp = this.channel.postRequestAndWait(req);
                    dis = resp.createDataInputStream();
                    if (dis.readInt() == objects.ordinal()) break block6;
                    return false;
                }
                if (dis.readInt() == classes.ordinal()) break block7;
                return false;
            }
            try {
                return dis.readInt() == classLoaders.ordinal();
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            catch (MemLeakServerException e) {
                MlpUtil.log(e);
            }
        }
        return false;
    }

    @Override
    protected void initFeatures(EnumSet<Feature> features, EnumSet<RequestType> requests) {
        super.initFeatures(features, requests);
        if (requests.contains((Object)RequestType.REQ_HEAP_HISTOGRAM_R28) && requests.contains((Object)RequestType.REQ_SET_TREND_ENABLED) && requests.contains((Object)RequestType.REQ_IS_TREND_ENABLED)) {
            features.add(Feature.TREND_ANALYSIS);
        }
        if (requests.contains((Object)RequestType.REQ_ENABLE_ALLOC_TRACE_R28) && requests.contains((Object)RequestType.REQ_DISABLE_ALLOC_TRACE) && requests.contains((Object)RequestType.REQ_IS_ALLOC_TRACE_ENABLED) && requests.contains((Object)RequestType.REQ_SET_ALLOC_TRACE_FREQ) && requests.contains((Object)RequestType.REQ_GET_ALLOC_TRACE_FREQ) && requests.contains((Object)RequestType.REQ_POLL_ALLOC_TRACES)) {
            features.add(Feature.ALLOCATION_TRACES);
        }
        if (requests.contains((Object)RequestType.REQ_DELETE_OBJIDS_R28)) {
            features.add(Feature.DELETE_OBJECT_ID);
        }
        if (requests.contains((Object)RequestType.REQ_DELETE_ALL_OBJIDS)) {
            features.add(Feature.DELETE_ALL_OBJECT_IDS);
        }
        if (requests.contains((Object)RequestType.REQ_PATHS_TO_ROOT)) {
            features.add(Feature.INSTANCE_PATHS_TO_ROOT);
        }
        if (requests.contains((Object)RequestType.REQ_INSTANCES_OF)) {
            features.add(Feature.INSTANCES_OF_TYPE);
        }
        if (requests.contains((Object)RequestType.REQ_GET_CLASSES)) {
            features.add(Feature.CLASS_IDS);
            features.add(Feature.CLASS_IDS_ARE_OBJECT_IDS);
        }
        if (requests.contains((Object)RequestType.REQ_GET_OBJECT_META_DATA) && requests.contains((Object)RequestType.REQ_GET_CLASS_META_DATA)) {
            features.add(Feature.CLASS_NAME_OF_OBJECT);
        }
        if (requests.contains((Object)RequestType.REQ_GET_CLASS_META_DATA)) {
            features.add(Feature.CLASS_LOADERS);
        }
        features.add(Feature.FIELD_MODIFIERS);
        features.add(Feature.METHOD_MODIFIERS);
        if (requests.contains((Object)RequestType.REQ_SET_AND_GET_PROTOCOL_VERBOSITY)) {
            features.add(Feature.CLASS_MODIFIERS);
        }
        if (requests.contains((Object)RequestType.REQ_GET_DISCARDED)) {
            features.add(Feature.TYPED_SERVER_EXCEPTIONS);
        }
    }

    protected int[] getRequestRevisions() {
        if (this.requestRevisions == null) {
            int[] revs = new int[RequestType.values().length];
            try {
                if (this.supportsRequest(RequestType.REQ_GET_BEHAVIORAL_REVISIONS)) {
                    int reqNo;
                    ServerRequest req = new ServerRequest(RequestType.REQ_GET_BEHAVIORAL_REVISIONS);
                    ServerResponse resp = this.channel.postRequestAndWait(req);
                    DataInputStream in = resp.createDataInputStream();
                    while ((reqNo = in.readInt()) != 0) {
                        revs[RequestType.get((int)reqNo).ordinal()] = in.readInt();
                    }
                }
            }
            catch (MemLeakServerException e) {
                MlpUtil.log(e);
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            this.requestRevisions = revs;
        }
        return this.requestRevisions;
    }

    @Override
    public Object getMetaData(Object key) {
        if ("MLP_REQUEST_REVISIONS".equals(key)) {
            return this.getRequestRevisions();
        }
        return super.getMetaData(key);
    }

    @Override
    protected ServerRequest createHeapHistogramReq() {
        ServerRequest req = new ServerRequest(RequestType.REQ_HEAP_HISTOGRAM_R28);
        return req;
    }

    @Override
    protected ServerRequest createTypesPointingToReq(ITypeSpecifier type) throws IOException, MemLeakServerException {
        int[] typeIDs = this.resolver.resolve(type);
        ServerRequest req = new ServerRequest(RequestType.REQ_TYPES_POINTING_TO_R28);
        this.addIDArrayArgument(req, typeIDs);
        return req;
    }

    private void addIDArrayArgument(ServerRequest req, int[] ids) throws IOException {
        req.addArgument(ids.length);
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            req.addArgument(id);
            ++n2;
        }
    }

    @Override
    public ITruncatable<IArraySizeInfo> getLargestArrays(ITypeSpecifier type) throws IOException, MemLeakServerException, NotAnArrayException {
        return new LargestArrayR28(type).send();
    }

    @Override
    public IInstanceReferrers getInstancesPointingTo(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_INSTANCES_POINTING_TO_R28);
        req.addArgument(objectSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = this.getInputStreamHandlingDiscarded(resp, objectSpec);
        try {
            IInstanceReferrers iInstanceReferrers = this.parseInstancePointingTo(dis);
            return iInstanceReferrers;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    protected DataInputStream getInputStreamHandlingDiscarded(ServerResponse response, IObjectSpecifier objectSpec) throws IOException, MemLeakServerException {
        try {
            return response.createDataInputStream();
        }
        catch (GarbageCollectedException e) {
            IObjectInfo objectInfo = this.infoCache.getObjectInfo(objectSpec);
            if (objectInfo != null) {
                this.factory.markDiscarded(objectInfo);
            }
            throw e;
        }
    }

    protected IInstanceReferrers parseInstancePointingTo(DataInputStream dis) throws IOException, MemLeakServerException {
        int tag;
        if (dis.available() == 0) {
            return null;
        }
        IObjectInfo targetInfo = this.parseObject(dis);
        if (targetInfo == INVALID_OBJECT_INFO) {
            return null;
        }
        ArrayList<IObjectInfo> objectinfos = new ArrayList<IObjectInfo>();
        ArrayList<IStaticField> staticfields = new ArrayList<IStaticField>();
        ArrayList<IThreadRoot> threadroots = new ArrayList<IThreadRoot>();
        int globalHandles = 0;
        while ((tag = dis.readInt()) != -1) {
            switch (tag) {
                case -2: {
                    objectinfos.add(this.parseObject(dis));
                    break;
                }
                case -3: {
                    IFieldInfo fi = this.parseFieldInfo(dis);
                    IStaticField sf = this.factory.createStaticField(fi.getDeclaringClassInfo(), fi.getName(), fi.getModifiers());
                    staticfields.add(sf);
                    break;
                }
                case -4: {
                    String threadName = dis.readUTF();
                    IMethodInfo method = this.parseMethodInfo(dis);
                    threadroots.add(this.factory.createThreadRoot(threadName, method));
                    break;
                }
                case -5: {
                    ++globalHandles;
                    break;
                }
                default: {
                    this.reportIgnoredBytes(4);
                }
            }
        }
        IObjectInfo[] ois = objectinfos.toArray(IObjectInfo.EMPTY_ARRAY);
        IStaticField[] staticFields = staticfields.toArray(IStaticField.EMPTY_ARRAY);
        IThreadRoot[] threadRoots = threadroots.toArray(IThreadRoot.EMPTY_ARRAY);
        return this.factory.createInstanceReferrers(targetInfo, ois, staticFields, threadRoots, globalHandles);
    }

    @Override
    public ITruncatable<IInstanceReferrers> getPathPointingTo(IObjectSpecifier objectSpec, int maxDepth, int maxMillis) throws IOException, MemLeakServerException {
        if (this.supportsRequest(RequestType.REQ_PATHS_TO_ROOT)) {
            IInstanceReferrers iref;
            ArrayList<IInstanceReferrers> path = new ArrayList<IInstanceReferrers>();
            ServerRequest req = new ServerRequest(RequestType.REQ_PATHS_TO_ROOT);
            req.addArgument(objectSpec);
            req.addArgument(maxDepth);
            req.addArgument(maxMillis);
            ServerResponse resp = this.channel.postRequestAndWait(req);
            DataInputStream dis = this.getInputStreamHandlingDiscarded(resp, objectSpec);
            while ((iref = this.parseInstancePointingTo(dis)) != null) {
                path.add(iref);
            }
            return new KnownTruncatable<IInstanceReferrers>(path.toArray(IInstanceReferrers.EMPTY_ARRAY), resp.getFlagsAsReason());
        }
        return super.getPathPointingTo(objectSpec, maxDepth, maxMillis);
    }

    @Override
    public ITruncatable<IRelationshipInfo> getInstanceRelationships(ITypeSpecifier fromType, ITypeSpecifier toType, int maxRelations, long stopAt, int maxMillis) throws IOException, MemLeakServerException {
        int[] fromIDs = this.resolver.resolve(fromType);
        int[] toIDs = this.resolver.resolve(toType);
        return new GetInstanceRelationshipsR28(fromIDs, toIDs, maxRelations, stopAt, maxMillis).send();
    }

    @Override
    public long getKeepAliveSizeOf(IObjectSpecifier objectSpec, long stopAt, long oldestAcceptable) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_KEEP_ALIVE_SIZE_R28);
        req.addArgument(objectSpec);
        req.addArgument(stopAt);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = this.getInputStreamHandlingDiscarded(resp, objectSpec);
        try {
            long l = dis.readLong();
            return l;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IFieldValue[] getFieldValues(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, IllegalArgumentException, MemLeakServerException {
        this.checkSpecValidity(objectSpec);
        ServerRequest req = new ServerRequest(RequestType.REQ_FIELD_VALUES_R28);
        req.addArgument(objectSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = this.getInputStreamHandlingDiscarded(resp, objectSpec);
        try {
            IFieldValue[] iFieldValueArray = this.parseFieldValues(dis, false);
            return iFieldValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IFieldValue[] getStaticFields(IClassRef classRef) throws IOException, IllegalArgumentException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_FIELD_VALUES_R28);
        req.addArgument(classRef.getClassId());
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IFieldValue[] iFieldValueArray = this.parseFieldValues(dis, true);
            return iFieldValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IValue[] getArrayData(IObjectSpecifier objectSpec, int from, int len) throws IOException, IllegalArgumentException, MemLeakServerException {
        this.checkSpecValidity(objectSpec);
        if (from < 0 || len < 0) {
            throw new IllegalArgumentException("parameters from and len have to be >= 0");
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_ARRAY_DATA_R28);
        req.addArgument(objectSpec);
        req.addArgument(from);
        req.addArgument(len);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = this.getInputStreamHandlingDiscarded(resp, objectSpec);
        try {
            this.parseObject(dis, null, false);
            dis.readInt();
            int count = dis.readInt();
            char type = dis.readChar();
            IValue[] vs = new IValue[count];
            int i = 0;
            while (i < count) {
                vs[i] = type == 'L' || type == '[' ? this.factory.createReferenceValue(this.parseObject(dis)) : this.factory.createPrimitiveValue(this.readPrimitive(dis, type));
                ++i;
            }
            IValue[] iValueArray = vs;
            return iValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    protected ServerRequest createEnableAllocTracesForClassReq(ITypeSpecifier type, int bufferSize, int interval) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_ENABLE_ALLOC_TRACE_R28);
        int[] typeIDs = this.resolver.resolve(type);
        req.addArgument(typeIDs[0]);
        req.addArgument(bufferSize);
        req.addArgument(interval);
        return req;
    }

    @Override
    public void deleteObjectId(int objectId) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_DELETE_OBJIDS_R28);
        req.addArgument(1);
        req.addArgument(objectId);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    @Override
    public void deleteObjectIds(int ... objectIds) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_DELETE_OBJIDS_R28);
        this.addIDArrayArgument(req, objectIds);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllObjectIds() throws IOException, MemLeakServerException {
        ServerResponse resp = this.channel.postRequestAndWait(new ServerRequest(RequestType.REQ_DELETE_ALL_OBJIDS));
        IInfoCacheControl iInfoCacheControl = this.infoCache;
        synchronized (iInfoCacheControl) {
            this.jlcClassInfo = null;
        }
        resp.throwAnyError();
    }

    @Override
    public int getArrayLength(IObjectSpecifier objectSpec) throws IOException, IllegalArgumentException, MemLeakServerException {
        IObjectInfo info = this.getObjectInfo(objectSpec);
        if (!(info instanceof IArrayInfo)) {
            throw new NotAnArrayException(info.toString());
        }
        return ((IArrayInfo)info).getLength();
    }

    @Override
    public IObjectInfo getObjectInfo(IObjectSpecifier objectSpec) throws IOException, MemLeakServerException {
        if (objectSpec == null) {
            return null;
        }
        this.checkSpecValidity(objectSpec);
        return this.getObjectInfo(objectSpec.getObjectId());
    }

    protected IObjectInfo getObjectInfo(int objID) throws IOException, MemLeakServerException {
        if (objID < 0) {
            return null;
        }
        IObjectInfo objInfo = this.infoCache.getObjectInfo(objID);
        if (objInfo != null) {
            return objInfo;
        }
        IClassInfo clsInfo = this.infoCache.getClassInfo(objID);
        if (clsInfo != null) {
            return this.factory.createObjectInfo(objID, this.jlcClassInfo);
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_GET_OBJECT_META_DATA);
        req.addArgument(objID);
        req.addVerbosity(MlpVerbosity.ALL, MlpVerbosity.ALL, null);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IObjectInfo iObjectInfo = (IObjectInfo)this.parseObject(dis, null, false);
            return iObjectInfo;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IClassInfo getClassInfo(IClassRef classRef) throws IOException, MemLeakServerException {
        return classRef == null ? null : this.getClassInfo(classRef.getClassId());
    }

    protected IClassInfo getClassInfo(int classID) throws IOException, MemLeakServerException {
        if (classID < 0) {
            return null;
        }
        IClassInfo clsInfo = this.infoCache.getClassInfo(classID);
        if (clsInfo != null) {
            return clsInfo;
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_GET_CLASS_META_DATA);
        req.addArgument(classID);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            if (dis.readInt() != -18) {
                throw new MemLeakServerException("Server implementation error");
            }
            IClassInfo iClassInfo = this.parseClassWithMetaData(dis);
            return iClassInfo;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IClassRef[] getClasses(ITypeSpecifier type, long oldestAcceptable) throws IOException, MemLeakServerException {
        int[] classIDs = this.resolver.resolve(type);
        IClassRef[] refs = new IClassRef[classIDs.length];
        int i = 0;
        while (i < refs.length) {
            refs[i] = this.infoCache.getClassRef(classIDs[i]);
            ++i;
        }
        return refs;
    }

    @Override
    public ITruncatable<IObjectInfo> getInstances(IClassRef classRef, int maxInstances) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_INSTANCES_OF);
        req.addArgument(classRef.getClassId());
        req.addArgument(maxInstances);
        this.channel.postRequest(req);
        IClassInfo classInfo = (IClassInfo)classRef.select(this.classInfoResolver);
        ServerResponse resp = this.channel.waitForReply(req.getId());
        DataInputStream dis = resp.createDataInputStream();
        try {
            IObjectInfo objInfo;
            ArrayList<IObjectInfo> infos = new ArrayList<IObjectInfo>();
            while ((objInfo = (IObjectInfo)this.parseObject(dis, classInfo, true)) != INVALID_OBJECT_INFO) {
                infos.add(objInfo);
            }
            KnownTruncatable<IObjectInfo> knownTruncatable = new KnownTruncatable<IObjectInfo>(infos.toArray(IObjectInfo.EMPTY_ARRAY), resp.getFlagsAsReason());
            return knownTruncatable;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    protected ITrace[] parseAllocTraces(DataInputStream dis) throws IOException, MemLeakServerException {
        if (dis.available() == 0) {
            return null;
        }
        int numTraces = dis.readInt();
        ITrace[] traces = new ITrace[numTraces];
        int i = 0;
        while (i < numTraces) {
            int count = dis.readInt();
            int numFrames = dis.readInt();
            ILocation[] locs = new ILocation[numFrames];
            int j = 0;
            while (j < numFrames) {
                IMethodInfo methodInfo = this.parseMethodInfo(dis);
                int line = dis.readInt();
                locs[j] = this.factory.createLocation(methodInfo, line);
                ++j;
            }
            traces[i] = this.factory.createTrace(count, locs);
            ++i;
        }
        return traces;
    }

    @Override
    protected IFieldValue[] parseFieldValues(DataInputStream dis, boolean onlyStatics) throws IOException, MemLeakServerException {
        if (dis.available() == 0) {
            return null;
        }
        this.parseObject(dis, null, false);
        int count = dis.readInt();
        ArrayList<IFieldValue> fieldVals = new ArrayList<IFieldValue>(count);
        int i = 0;
        while (i < count) {
            IFieldInfo name = this.parseFieldInfo(dis);
            char type = dis.readChar();
            IFieldValue fieldVal = type == 'L' || type == '[' ? this.factory.createReferenceFieldValue(name, this.parseObject(dis)) : this.factory.createPrimitiveFieldValue(name, this.readPrimitive(dis, type));
            if (!onlyStatics || Modifier.isStatic(name.getModifiers())) {
                fieldVals.add(fieldVal);
            }
            ++i;
        }
        return fieldVals.toArray(IFieldValue.EMPTY_ARRAY);
    }

    private IFieldInfo parseFieldInfo(DataInputStream dis) throws IOException, MemLeakServerException {
        IClassInfo classInfo = this.parseClass(dis);
        String fname = dis.readUTF();
        int modifiers = dis.readInt();
        return this.factory.createFieldInfo(classInfo, fname, modifiers);
    }

    @Override
    protected IMethodInfo parseMethodInfo(DataInputStream dis) throws IOException, MemLeakServerException {
        IClassInfo declaringClassInfo = this.parseClass(dis);
        if (declaringClassInfo == null) {
            return null;
        }
        String name = dis.readUTF();
        String descriptor = dis.readUTF();
        int modifiers = dis.readInt();
        return this.factory.createMethodInfo(declaringClassInfo, name, descriptor, modifiers);
    }

    @Override
    protected IObjectInfo parseObject(DataInputStream dis) throws IOException, MemLeakServerException {
        return (IObjectInfo)this.parseObject(dis, null, true);
    }

    @Override
    protected IObjectSpecifier parseObject(DataInputStream dis, IClassInfo classInfo, boolean needInfo) throws IOException, MemLeakServerException {
        int objectID = dis.readInt();
        switch (objectID) {
            case -1: {
                return INVALID_OBJECT_INFO;
            }
            case -2: {
                return null;
            }
            case -19: {
                objectID = dis.readInt();
                int len = dis.readInt();
                classInfo = this.parseClass(dis);
                assert (classInfo.isArrayClass()) : classInfo;
                return this.factory.createArrayInfo(objectID, classInfo, len);
            }
            case -17: {
                objectID = dis.readInt();
                classInfo = this.parseClass(dis);
                assert (!classInfo.isArrayClass()) : classInfo;
                break;
            }
            case -18: {
                IClassInfo classView = this.parseClassWithMetaData(dis);
                objectID = classView.getClassObjectSpec().getObjectId();
                classInfo = this.findJavaLangClass();
            }
        }
        if (classInfo == null) {
            IObjectSpecifier objSpec = this.infoCache.getObjectSpec(objectID);
            if (!needInfo || objSpec instanceof IObjectInfo) {
                return objSpec;
            }
            return this.getObjectInfo(objectID);
        }
        return this.factory.createObjectInfo(objectID, classInfo);
    }

    protected IClassInfo parseClassWithMetaData(DataInputStream dis) throws IOException, MemLeakServerException {
        int classID = dis.readInt();
        String className = dis.readUTF();
        int modifiers = dis.readInt();
        int numDeclaredStaticFields = dis.readInt();
        int numInstanceFields = dis.readInt();
        String srcFileName = dis.readUTF();
        IObjectSpecifier loaderSpec = this.parseObject(dis, null, false);
        return this.factory.createClassInfo(classID, className, modifiers, numDeclaredStaticFields, numInstanceFields, srcFileName, loaderSpec);
    }

    @Override
    protected IClassInfo parseClass(DataInputStream dis) throws IOException, MemLeakServerException {
        return (IClassInfo)this.parseClass(dis, true);
    }

    protected IClassRef parseClass(DataInputStream dis, boolean needInfo) throws IOException, MemLeakServerException {
        int classID = dis.readInt();
        switch (classID) {
            case -1: {
                return INVALID_CLASS_INFO;
            }
            case -2: {
                return null;
            }
            case -18: {
                return this.parseClassWithMetaData(dis);
            }
        }
        IClassInfo classInfo = this.infoCache.getClassInfo(classID);
        if (classInfo != null) {
            return classInfo;
        }
        if (!needInfo) {
            return this.infoCache.getClassRef(classID);
        }
        return this.getClassInfo(classID);
    }

    public int[] getDiscardedIDs(IObjectSpecifier ... objectSpecs) throws IOException, MemLeakServerException {
        int id;
        if (!this.supportsRequest(RequestType.REQ_GET_DISCARDED)) {
            throw new UnsupportedOperationException();
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_GET_DISCARDED);
        if (objectSpecs == null) {
            req.addArgument(-1);
        } else {
            req.addArgument(objectSpecs.length);
            IObjectSpecifier[] iObjectSpecifierArray = objectSpecs;
            int n = objectSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                IObjectSpecifier spec = iObjectSpecifierArray[n2];
                req.addArgument(spec);
                ++n2;
            }
        }
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        int maxIDs = dis.available() / 4 - 1;
        int[] ids = new int[maxIDs];
        int i = 0;
        while ((id = dis.readInt()) != -1) {
            ids[i++] = id;
        }
        if (i < maxIDs) {
            int[] newIDs = new int[i];
            System.arraycopy(ids, 0, newIDs, 0, i);
            ids = newIDs;
        }
        return ids;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIdResolver
    implements ITypeResolver<int[]> {
        private ClassIdResolver() {
        }

        public int[] resolve(ITypeSpecifier type) {
            return type.select(this);
        }

        @Override
        public int[] withClassID(int id) {
            return new int[]{id};
        }

        @Override
        public int[] withClassName(String className) {
            try {
                return (int[])new GetClassesR28(className).get();
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            catch (ExecutionException e) {
                MlpUtil.log(e);
            }
            return new int[0];
        }

        @Override
        public int[] withClassNameAndID(String className, int id) {
            return new int[]{id};
        }

        @Override
        public int[] withClassNameAndIDs(String className, int ... ids) {
            return ids;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassInfoResolver
    implements ITypeResolver<IClassInfo> {
        private ClassInfoResolver() {
        }

        @Override
        public IClassInfo withClassID(int id) {
            try {
                return MemLeakR28.this.getClassInfo(id);
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            catch (MemLeakServerException e) {
                MlpUtil.log(e);
            }
            return null;
        }

        @Override
        public IClassInfo withClassName(String className) {
            try {
                return this.withClassNameAndIDs(className, (int[])new GetClassesR28(className).get());
            }
            catch (ExecutionException e) {
                MlpUtil.log(e);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public IClassInfo withClassNameAndID(String className, int id) {
            IClassInfo info = MemLeakR28.this.infoCache.getClassInfo(id);
            if (info != null) {
                return info;
            }
            return MemLeakR28.this.factory.createClassInfo(id, className, 0, -1, -1, null, null);
        }

        @Override
        public IClassInfo withClassNameAndIDs(String className, int ... ids) {
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                IClassInfo info = MemLeakR28.this.infoCache.getClassInfo(id);
                if (info != null) {
                    return info;
                }
                ++n2;
            }
            return MemLeakR28.this.factory.createClassInfo(ids[0], className, 0, -1, -1, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetClassesR28
    extends AbstractMemLeak.ReqProcessor<int[]> {
        public GetClassesR28(String refType) throws IOException {
            super(RequestType.REQ_GET_CLASSES);
            this.req.addArgument(refType);
        }

        @Override
        protected int[] parseResponse(DataInputStream dis) throws IOException, MemLeakServerException {
            int n = dis.readInt();
            int[] vec = new int[n];
            int i = 0;
            while (i < n) {
                vec[i] = MemLeakR28.this.parseClass(dis, false).getClassId();
                ++i;
            }
            return vec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetInstanceRelationshipsR28
    extends AbstractMemLeak.DelayedTruncatable<IRelationshipInfo> {
        public GetInstanceRelationshipsR28(int[] fromIDs, int[] toIDs, int maxRelations, long stopAt, int maxMillis) throws IOException {
            super(RequestType.REQ_INSTANCE_RELATIONSHIP_R28);
            MemLeakR28.this.addIDArrayArgument(this.req, fromIDs);
            MemLeakR28.this.addIDArrayArgument(this.req, toIDs);
            this.req.addArgument(maxRelations);
            this.req.addArgument(stopAt);
            this.req.addArgument(maxMillis);
        }

        protected IRelationshipInfo[] parseResponse(DataInputStream dis) throws IOException, MemLeakServerException {
            IObjectInfo fromObj;
            ArrayList<IRelationshipInfo> ar = new ArrayList<IRelationshipInfo>();
            while ((fromObj = MemLeakR28.this.parseObject(dis)) != INVALID_OBJECT_INFO) {
                long keepalive_size = dis.readLong();
                IRelationshipInfo rel = MemLeakR28.this.factory.createRelationshipInfo(fromObj, keepalive_size);
                ar.add(rel);
            }
            return ar.toArray(new IRelationshipInfo[ar.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LargestArrayR28
    extends AbstractMemLeak.DelayedTruncatable<IArraySizeInfo> {
        public LargestArrayR28(ITypeSpecifier type) throws IOException {
            super(RequestType.REQ_LARGEST_ARRAYS_R28);
            if (type instanceof INamedType && !TypeSpecifierHelper.isArrayType((INamedType)type)) {
                throw new NotAnArrayException("Not an array type");
            }
            MemLeakR28.this.addIDArrayArgument(this.req, MemLeakR28.this.resolver.resolve(type));
        }

        protected IArraySizeInfo[] parseResponse(DataInputStream dis) throws IOException, MemLeakServerException {
            IClassInfo classInfo;
            ArrayList<IArraySizeInfo> arraySizes = new ArrayList<IArraySizeInfo>();
            while ((classInfo = MemLeakR28.this.parseClass(dis)) != INVALID_CLASS_INFO) {
                int n = dis.readInt();
                int i = 0;
                while (i < n) {
                    IArrayInfo arrayInfo = (IArrayInfo)MemLeakR28.this.parseObject(dis, classInfo, true);
                    long size = dis.readLong();
                    arraySizes.add(MemLeakR28.this.factory.createArraySizeInfo(arrayInfo, size));
                    ++i;
                }
            }
            return arraySizes.toArray(IArraySizeInfo.EMPTY_ARRAY);
        }
    }
}

