/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.Feature;
import com.jrockit.memleak.IArrayInfo;
import com.jrockit.memleak.IArraySizeInfo;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IClassRef;
import com.jrockit.memleak.IFieldInfo;
import com.jrockit.memleak.IFieldValue;
import com.jrockit.memleak.IInstanceReferrers;
import com.jrockit.memleak.ILocation;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IMethodInfo;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.IRelationshipInfo;
import com.jrockit.memleak.IStaticField;
import com.jrockit.memleak.IThreadRoot;
import com.jrockit.memleak.ITrace;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.IValue;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NoSuchIdException;
import com.jrockit.memleak.NotAnArrayException;
import com.jrockit.memleak.mlp.AbstractMemLeak;
import com.jrockit.memleak.mlp.CommunicationChannel;
import com.jrockit.memleak.mlp.MlpUtil;
import com.jrockit.memleak.mlp.NameMappingCacheFactory;
import com.jrockit.memleak.mlp.RequestType;
import com.jrockit.memleak.mlp.ServerRequest;
import com.jrockit.memleak.mlp.ServerResponse;
import com.jrockit.memleak.util.DummyClassInfo;
import com.jrockit.memleak.util.DummyObjectInfo;
import com.jrockit.memleak.util.TypeResolverAdapter;
import com.jrockit.memleak.value.KnownTruncatable;
import com.jrockit.memleak.value.ValueFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemLeakR26
extends AbstractMemLeak {
    private static final IObjectInfo UNKNOWN_CLASS_LOADER = DummyObjectInfo.createNested("unknown", 2);
    private final IClassInfo unfetchedClassInfo;
    private final ClassNameResolver resolver = new ClassNameResolver();
    private NameMappingCacheFactory nameMapper;

    public MemLeakR26(String host, int port) throws IOException {
        this(new CommunicationChannel(host, port), port);
    }

    public MemLeakR26(CommunicationChannel channel, int port) {
        super(channel, port);
        this.enabledRequests = this.createSafeSupportedReqs();
        this.classInfoResolver = new ClassInfoResolver();
        this.unfetchedClassInfo = DummyClassInfo.createNested("unfetched class", 2);
    }

    @Override
    public void setFactory(IMemleakValueFactory factory) {
        factory = factory != null ? factory : ValueFactory.getDefault();
        this.nameMapper = factory instanceof NameMappingCacheFactory ? (NameMappingCacheFactory)factory : new NameMappingCacheFactory(factory, UNKNOWN_CLASS_LOADER);
        super.setFactory(this.nameMapper);
    }

    @Override
    protected void initFeatures(EnumSet<Feature> features, EnumSet<RequestType> requests) {
        super.initFeatures(features, requests);
        if (requests.contains((Object)RequestType.REQ_HEAP_HISTOGRAM_R26) && requests.contains((Object)RequestType.REQ_SET_TREND_ENABLED) && requests.contains((Object)RequestType.REQ_IS_TREND_ENABLED)) {
            features.add(Feature.TREND_ANALYSIS);
        }
        if (requests.contains((Object)RequestType.REQ_ENABLE_ALLOC_TRACE_R26) && requests.contains((Object)RequestType.REQ_DISABLE_ALLOC_TRACE) && requests.contains((Object)RequestType.REQ_IS_ALLOC_TRACE_ENABLED) && requests.contains((Object)RequestType.REQ_SET_ALLOC_TRACE_FREQ) && requests.contains((Object)RequestType.REQ_GET_ALLOC_TRACE_FREQ) && requests.contains((Object)RequestType.REQ_POLL_ALLOC_TRACES)) {
            features.add(Feature.ALLOCATION_TRACES);
        }
        if (requests.contains((Object)RequestType.REQ_DELETE_OBJID_R26)) {
            features.add(Feature.DELETE_OBJECT_ID);
        }
    }

    @Override
    protected ServerRequest createHeapHistogramReq() {
        ServerRequest req = new ServerRequest(RequestType.REQ_HEAP_HISTOGRAM_R26);
        return req;
    }

    @Override
    protected ServerRequest createTypesPointingToReq(ITypeSpecifier type) throws IOException {
        ServerRequest req = new ServerRequest(RequestType.REQ_TYPES_POINTING_TO_R26);
        req.addArgument(this.resolver.resolve(type));
        return req;
    }

    @Override
    public ITruncatable<IArraySizeInfo> getLargestArrays(ITypeSpecifier type) throws IOException, MemLeakServerException, NotAnArrayException {
        return new LargestArrayR26(type).send();
    }

    @Override
    public IInstanceReferrers getInstancesPointingTo(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_INSTANCES_POINTING_TO_R26);
        req.addArgument(objectSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IInstanceReferrers iInstanceReferrers = this.parseInstancePointingTo(this.infoCache.getObjectInfo(objectSpec), dis);
            return iInstanceReferrers;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    protected ServerRequest createInstanceRelationshipsReq(ITypeSpecifier fromType, ITypeSpecifier toType, int maxRelations, long stopAt, int maxMillis) throws IOException {
        ServerRequest req = new ServerRequest(RequestType.REQ_INSTANCE_RELATIONSHIP_R26);
        req.addArgument(this.resolver.resolve(fromType));
        req.addArgument(this.resolver.resolve(toType));
        req.addArgument(maxRelations);
        req.addArgument(stopAt < 0L ? 0L : (stopAt == 0L ? -1L : stopAt));
        req.addArgument(maxMillis < 0 ? 0 : Math.max(1, (maxMillis + 500) / 1000));
        return req;
    }

    @Override
    public IFieldValue[] getFieldValues(IObjectSpecifier objectSpec, long oldestAcceptable) throws IOException, IllegalArgumentException, MemLeakServerException {
        this.checkSpecValidity(objectSpec);
        ServerRequest req = new ServerRequest(RequestType.REQ_FIELD_VALUES_R26);
        req.addArgument(objectSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IFieldValue[] iFieldValueArray = this.parseFieldValues(dis, false);
            return iFieldValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IFieldValue[] getStaticFields(IClassRef classRef) throws IOException, IllegalArgumentException, MemLeakServerException {
        IObjectSpecifier jlcSpec;
        IClassInfo classInfo = this.infoCache.getClassInfo(classRef.getClassId());
        IObjectSpecifier iObjectSpecifier = jlcSpec = classInfo == null ? null : classInfo.getClassObjectSpec();
        if (jlcSpec == null) {
            throw new UnsupportedOperationException("Cannot find out for this class yet.");
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_FIELD_VALUES_R26);
        req.addArgument(jlcSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IFieldValue[] iFieldValueArray = this.parseFieldValues(dis, true);
            return iFieldValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    public IValue[] getArrayData(IObjectSpecifier objectSpec, int from, int len) throws IOException, IllegalArgumentException, MemLeakServerException {
        this.checkSpecValidity(objectSpec);
        if (from < 0 || len < 0) {
            throw new IllegalArgumentException("parameters from and len have to be >= 0");
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_ARRAY_DATA_R26);
        req.addArgument(objectSpec);
        req.addArgument(from);
        req.addArgument(len);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            int count = dis.readInt();
            if (count != len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            char type = dis.readChar();
            IValue[] vs = new IValue[count];
            int i = 0;
            while (i < count) {
                vs[i] = type == 'L' || type == '[' ? this.factory.createReferenceValue(this.parseObjectAndClass(dis)) : this.factory.createPrimitiveValue(this.readPrimitive(dis, type));
                ++i;
            }
            IValue[] iValueArray = vs;
            return iValueArray;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    @Override
    protected ServerRequest createEnableAllocTracesForClassReq(ITypeSpecifier type, int bufferSize, int interval) throws IOException {
        ServerRequest req = new ServerRequest(RequestType.REQ_ENABLE_ALLOC_TRACE_R26);
        req.addArgument(this.resolver.resolve(type));
        req.addArgument(bufferSize);
        req.addArgument(interval);
        return req;
    }

    private IInstanceReferrers parseInstancePointingTo(IObjectInfo targetInfo, DataInputStream dis) throws IOException {
        int tag;
        if (dis.available() == 0) {
            return null;
        }
        ArrayList<IObjectInfo> objectinfos = new ArrayList<IObjectInfo>();
        ArrayList<IStaticField> staticfields = new ArrayList<IStaticField>();
        ArrayList<IThreadRoot> threadroots = new ArrayList<IThreadRoot>();
        int globalHandles = 0;
        while ((tag = dis.readInt()) != -1) {
            switch (tag) {
                case -2: {
                    int objectId = dis.readInt();
                    IClassInfo classInfo = this.parseClass(dis);
                    objectinfos.add(this.factory.createObjectInfo(objectId, classInfo));
                    break;
                }
                case -3: {
                    String className = dis.readUTF();
                    String fieldName = dis.readUTF();
                    int classID = dis.readInt();
                    NameMappingCacheFactory.ClassInfoR26 classInfo = this.nameMapper.getOrCreateClassInfo(className);
                    if (classInfo.getClassObjectSpec() == null) {
                        classInfo.setClassObjectSpec(this.nameMapper.getObjectSpec(classID));
                    }
                    IStaticField sf = this.factory.createStaticField(classInfo, fieldName, 0);
                    staticfields.add(sf);
                    break;
                }
                case -4: {
                    String threadName = dis.readUTF();
                    IMethodInfo method = this.parseMethodInfo(dis);
                    threadroots.add(this.factory.createThreadRoot(threadName, method));
                    break;
                }
                case -5: {
                    ++globalHandles;
                }
            }
        }
        IObjectInfo[] ois = objectinfos.toArray(IObjectInfo.EMPTY_ARRAY);
        IStaticField[] staticFields = staticfields.toArray(IStaticField.EMPTY_ARRAY);
        IThreadRoot[] threadRoots = threadroots.toArray(IThreadRoot.EMPTY_ARRAY);
        return this.factory.createInstanceReferrers(targetInfo, ois, staticFields, threadRoots, globalHandles);
    }

    @Override
    protected ITrace[] parseAllocTraces(DataInputStream dis) throws IOException {
        if (dis.available() == 0) {
            return null;
        }
        int numTraces = dis.readInt();
        ITrace[] traces = new ITrace[numTraces];
        int i = 0;
        while (i < numTraces) {
            int count = dis.readInt();
            int numFrames = dis.readInt();
            ILocation[] locs = new ILocation[numFrames];
            int j = 0;
            while (j < numFrames) {
                IMethodInfo methodInfo = this.parseMethodInfo(dis);
                String srcFileName = dis.readUTF();
                IClassInfo classInfo = methodInfo.getDeclaringClassInfo();
                if (srcFileName != null && classInfo instanceof NameMappingCacheFactory.ClassInfoR26) {
                    ((NameMappingCacheFactory.ClassInfoR26)classInfo).setSourceFileName(srcFileName);
                }
                int line = dis.readInt();
                locs[j] = this.factory.createLocation(methodInfo, line);
                ++j;
            }
            traces[i] = this.factory.createTrace(count, locs);
            ++i;
        }
        return traces;
    }

    @Override
    protected IFieldValue[] parseFieldValues(DataInputStream dis, boolean onlyStatics) throws IOException, MemLeakServerException {
        if (dis.available() == 0) {
            return null;
        }
        int modifiers = onlyStatics ? 18191 : 18183;
        boolean seenJlc = false;
        int count = dis.readInt();
        ArrayList<IFieldValue> fieldVals = new ArrayList<IFieldValue>(count);
        int i = 0;
        while (i < count) {
            char type;
            IFieldInfo name = this.parseFieldInfo(dis, modifiers);
            if (!seenJlc && this.isJlcClass(name.getDeclaringClassInfo())) {
                seenJlc = true;
                modifiers = 18183;
                name = this.factory.createFieldInfo(name.getDeclaringClassInfo(), name.getName(), modifiers);
            }
            IFieldValue fieldVal = (type = dis.readChar()) == 'L' || type == '[' ? this.factory.createReferenceFieldValue(name, this.parseObjectAndClass(dis)) : this.factory.createPrimitiveFieldValue(name, this.readPrimitive(dis, type));
            if (!onlyStatics || !seenJlc) {
                fieldVals.add(fieldVal);
            }
            ++i;
        }
        return fieldVals.toArray(IFieldValue.EMPTY_ARRAY);
    }

    private IFieldInfo parseFieldInfo(DataInputStream dis, int modifiers) throws IOException {
        IClassInfo classInfo = this.parseClass(dis);
        String fname = dis.readUTF();
        return this.factory.createFieldInfo(classInfo, fname, modifiers);
    }

    @Override
    protected IMethodInfo parseMethodInfo(DataInputStream dis) throws IOException {
        IClassInfo declaringClassInfo = this.parseClass(dis);
        String name = dis.readUTF();
        String descriptor = dis.readUTF();
        return this.factory.createMethodInfo(declaringClassInfo, name, descriptor, 18183);
    }

    @Override
    protected IObjectInfo parseObject(DataInputStream dis) throws IOException {
        return (IObjectInfo)this.parseObject(dis, null, true);
    }

    @Override
    protected IObjectSpecifier parseObject(DataInputStream dis, IClassInfo classInfo, boolean needInfo) throws IOException {
        int objectId = dis.readInt();
        if (!needInfo) {
            return this.infoCache.getObjectSpec(objectId);
        }
        if (classInfo == null) {
            IObjectInfo info = this.infoCache.getObjectInfo(objectId);
            if (info != null) {
                return info;
            }
            classInfo = this.unfetchedClassInfo;
        }
        if (classInfo.isArrayClass()) {
            int len = -1;
            try {
                len = this.getArrayLength(this.infoCache.getObjectSpec(objectId));
            }
            catch (MemLeakServerException ignore) {
                MlpUtil.log(ignore);
            }
            return this.factory.createArrayInfo(objectId, classInfo, len);
        }
        return this.factory.createObjectInfo(objectId, classInfo);
    }

    @Override
    public IObjectInfo getObjectInfo(IObjectSpecifier objectSpec) throws IOException, MemLeakServerException {
        return this.infoCache.getObjectInfo(objectSpec.getObjectId());
    }

    protected IObjectInfo parseObjectAndClass(DataInputStream dis) throws IOException, MemLeakServerException {
        int objectId = dis.readInt();
        IClassInfo classInfo = this.parseClass(dis);
        if (objectId == -2) {
            return null;
        }
        if (classInfo.isArrayClass()) {
            int len;
            try {
                len = this.getArrayLength(this.infoCache.getObjectSpec(objectId));
            }
            catch (MemLeakServerException e) {
                throw new IOException(e.getMessage());
            }
            return this.factory.createArrayInfo(objectId, classInfo, len);
        }
        return this.factory.createObjectInfo(objectId, classInfo);
    }

    @Override
    protected IClassInfo parseClass(DataInputStream dis) throws IOException {
        String refType = dis.readUTF();
        return this.nameMapper.getOrCreateClassInfo(refType);
    }

    @Override
    public IClassInfo getClassInfo(IClassRef classRef) throws IOException, MemLeakServerException {
        return this.infoCache.getClassInfo(classRef.getClassId());
    }

    @Override
    public ITruncatable<IRelationshipInfo> getInstanceRelationships(ITypeSpecifier fromType, ITypeSpecifier toType, int maxRelations, long stopAt, int maxMillis) throws IOException, MemLeakServerException {
        ServerRequest req = this.createInstanceRelationshipsReq(fromType, toType, maxRelations, stopAt, maxMillis);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            ITruncatable<IRelationshipInfo> iTruncatable = this.parseInstanceRelationsships(dis, fromType);
            return iTruncatable;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    protected ITruncatable<IRelationshipInfo> parseInstanceRelationsships(DataInputStream dis, ITypeSpecifier fromType) throws IOException {
        int fromId;
        if (dis.available() == 0) {
            return null;
        }
        boolean timedout = dis.readBoolean();
        IClassInfo fromClassInfo = (IClassInfo)fromType.select(this.classInfoResolver);
        ArrayList<IRelationshipInfo> ar = new ArrayList<IRelationshipInfo>();
        while ((fromId = dis.readInt()) != -1) {
            long keepalive_size = dis.readLong();
            IRelationshipInfo rel = this.factory.createRelationshipInfo(this.factory.createObjectInfo(fromId, fromClassInfo), keepalive_size);
            ar.add(rel);
        }
        IRelationshipInfo[] ris = ar.toArray(new IRelationshipInfo[ar.size()]);
        return new KnownTruncatable<IRelationshipInfo>(ris, timedout ? ITruncatable.Reason.TIMEOUT : null);
    }

    @Override
    public long getKeepAliveSizeOf(IObjectSpecifier objectSpec, long stopAt, long oldestAcceptable) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_KEEP_ALIVE_SIZE_R26);
        req.addArgument(objectSpec);
        req.addArgument(stopAt < 0L ? 0L : (stopAt == 0L ? 1L : stopAt));
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            long l = dis.readLong();
            return l;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassInfoResolver
    extends TypeResolverAdapter<IClassInfo> {
        private ClassInfoResolver() {
        }

        @Override
        public IClassInfo withClassID(int classID) {
            IClassInfo info = MemLeakR26.this.infoCache.getClassInfo(classID);
            return info != null ? info : MemLeakR26.this.unfetchedClassInfo;
        }

        @Override
        public IClassInfo withClassName(String refType) {
            return MemLeakR26.this.nameMapper.getOrCreateClassInfo(refType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassNameResolver
    implements ITypeResolver<String> {
        private ClassNameResolver() {
        }

        public String resolve(ITypeSpecifier type) {
            return type.select(this);
        }

        @Override
        public String withClassID(int classID) {
            IClassInfo info = MemLeakR26.this.infoCache.getClassInfo(classID);
            return info != null ? info.getName() : null;
        }

        @Override
        public String withClassName(String className) {
            return className;
        }

        @Override
        public String withClassNameAndID(String className, int id) {
            IClassInfo info = MemLeakR26.this.infoCache.getClassInfo(id);
            assert (info != null);
            assert (info.getName().equals(className));
            return className;
        }

        @Override
        public String withClassNameAndIDs(String className, int ... ids) {
            assert (ids.length == 1);
            return this.withClassNameAndID(className, ids[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LargestArrayR26
    extends AbstractMemLeak.DelayedTruncatable<IArraySizeInfo> {
        private ITypeSpecifier type;

        public LargestArrayR26(ITypeSpecifier type) throws IOException {
            super(RequestType.REQ_LARGEST_ARRAYS_R26);
            this.type = type;
            String descriptor = MemLeakR26.this.resolver.resolve(type);
            if (descriptor == null) {
                throw new NoSuchIdException("Unmapped class ID.");
            }
            if (!descriptor.startsWith("[")) {
                throw new NotAnArrayException("type argument does not denote an array type.");
            }
            this.req.addArgument(descriptor);
        }

        protected IArraySizeInfo[] parseResponse(DataInputStream dis) throws IOException {
            int n = dis.readInt();
            IClassInfo classInfo = null;
            if (n > 0) {
                classInfo = (IClassInfo)this.type.select(MemLeakR26.this.classInfoResolver);
            }
            IArraySizeInfo[] asi = new IArraySizeInfo[n];
            int i = 0;
            while (i < n) {
                IArrayInfo arrayInfo = (IArrayInfo)MemLeakR26.this.parseObject(dis, classInfo, true);
                long size = dis.readLong();
                asi[i] = MemLeakR26.this.factory.createArraySizeInfo(arrayInfo, size);
                ++i;
            }
            return asi;
        }
    }
}

