/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IHeapHistogram;
import com.jrockit.memleak.INamedType;
import com.jrockit.memleak.ITypeHeapInfo;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.value.HeapInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinedTypeHeapInfo
extends HeapInfo
implements INamedType,
ITypeHeapInfo<INamedType>,
IHeapHistogram {
    private String refType;
    private List<ITypeHeapInfo<IClassInfo>> heapInfos;

    JoinedTypeHeapInfo(String refType, long creationMillis) {
        super(creationMillis);
        assert (refType != null);
        this.refType = refType;
        this.heapInfos = new ArrayList<ITypeHeapInfo<IClassInfo>>();
    }

    void add(ITypeHeapInfo<IClassInfo> heapInfo) {
        assert (heapInfo != null);
        assert (this.refType.equals(heapInfo.getType().getName()));
        this.heapInfos.add(heapInfo);
        this.numInstances += heapInfo.getNumberOfInstances();
        this.size += heapInfo.getSizeOfInstances();
        this.growthRate += heapInfo.getGrowthRate();
    }

    @Override
    public String getName() {
        return this.refType;
    }

    @Override
    public <T> T select(ITypeResolver<T> resolver) {
        return resolver.withClassName(this.refType);
    }

    @Override
    public INamedType getType() {
        return this;
    }

    @Override
    public Iterator<ITypeHeapInfo<IClassInfo>> iterator() {
        return this.heapInfos.iterator();
    }

    @Override
    public Collection<ITypeHeapInfo<IClassInfo>> getTypeHeapInfos() {
        return this.heapInfos;
    }

    @Override
    public Collection<? extends ITypeHeapInfo<?>> getGroupedTypeHeapInfos() {
        return this.heapInfos;
    }

    @Override
    public int hashCode() {
        return this.refType.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof JoinedTypeHeapInfo && this.equals((JoinedTypeHeapInfo)other);
    }

    protected boolean equals(JoinedTypeHeapInfo other) {
        return this.refType.equals(other.refType);
    }
}

