/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.IArrayInfo;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IClassRef;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.ITypeHeapInfo;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.util.DelegatingValueFactory;
import com.jrockit.memleak.util.IInfoCacheControl;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoCachingFactory
extends DelegatingValueFactory
implements IInfoCacheControl {
    private TreeMap<Integer, IObjectInfo> objectInfos = new TreeMap();
    private TreeMap<Integer, IClassInfo> classInfos = new TreeMap();
    private TreeMap<Integer, ITypeHeapInfo<IClassInfo>> heapInfos = new TreeMap();

    public InfoCachingFactory(IMemleakValueFactory delegate) {
        super(delegate);
    }

    @Override
    public IArrayInfo createArrayInfo(int objectID, IClassInfo classInfo, int length) {
        IArrayInfo arrayInfo = (IArrayInfo)this.getObjectInfo(objectID);
        if (arrayInfo != null) {
            assert (classInfo.equals(arrayInfo.getClassInfo())) : "<" + objectID + "> old: " + arrayInfo.getClassInfo() + ", new: " + classInfo;
            assert (length == arrayInfo.getLength()) : "<" + objectID + "> old: " + arrayInfo.getLength() + ", new: " + length;
            if (!classInfo.equals(arrayInfo.getClassInfo())) {
                System.err.println("<" + objectID + "> old: " + arrayInfo.getClassInfo() + ", new: " + classInfo);
            }
            if (length != arrayInfo.getLength()) {
                System.err.println("<" + objectID + "> old: " + arrayInfo.getLength() + ", new: " + length);
            }
            return arrayInfo;
        }
        arrayInfo = super.createArrayInfo(objectID, classInfo, length);
        this.objectInfos.put(objectID, arrayInfo);
        return arrayInfo;
    }

    @Override
    public IObjectSpecifier getObjectSpec(int objectID) {
        if (objectID == -2) {
            return null;
        }
        IObjectInfo info = this.getObjectInfo(objectID);
        return info != null ? info : new ObjSpec(objectID);
    }

    @Override
    public IObjectInfo getObjectInfo(IObjectSpecifier objectSpec) {
        return this.getObjectInfo(objectSpec.getObjectId());
    }

    @Override
    public synchronized IObjectInfo getObjectInfo(int objectID) {
        return this.objectInfos.get(objectID);
    }

    @Override
    public synchronized IObjectInfo createObjectInfo(int objectID, IClassInfo classInfo) {
        IObjectInfo objInfo = this.getObjectInfo(objectID);
        if (objInfo != null) {
            assert (classInfo.equals(objInfo.getClassInfo())) : "<" + objectID + "> old: " + objInfo.getClassInfo() + ", new: " + classInfo;
            if (!classInfo.equals(objInfo.getClassInfo())) {
                System.err.println("<" + objectID + "> old: " + objInfo.getClassInfo() + ", new: " + classInfo);
            }
            return objInfo;
        }
        objInfo = super.createObjectInfo(objectID, classInfo);
        this.objectInfos.put(objectID, objInfo);
        return objInfo;
    }

    @Override
    public synchronized void clearObjects(int ... objectIDs) {
        int[] nArray = objectIDs;
        int n = objectIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.objectInfos.remove(id);
            ++n2;
        }
    }

    @Override
    public IClassRef getClassRef(int classID) {
        if (classID == -2) {
            return null;
        }
        IClassInfo info = this.getClassInfo(classID);
        return info != null ? info : new ClassRef(classID);
    }

    @Override
    public synchronized IClassInfo getClassInfo(int classID) {
        return this.classInfos.get(classID);
    }

    @Override
    public synchronized IClassInfo createClassInfo(int classID, String name, int modifiers, int numDeclaredStaticFields, int numInstanceFields, String srcFileName, IObjectSpecifier classLoaderSpec) {
        IClassInfo classInfo = this.getClassInfo(classID);
        if (classInfo != null) {
            assert (name.equals(classInfo.getName())) : "old: " + classInfo.getName() + ", new: " + name;
            IObjectSpecifier oldLoader = classInfo.getClassLoaderSpec();
            assert (classLoaderSpec == oldLoader || oldLoader != null && classLoaderSpec.getObjectId() == oldLoader.getObjectId()) : "old: " + oldLoader + ", new: " + classLoaderSpec;
            return classInfo;
        }
        classInfo = super.createClassInfo(classID, name, modifiers, numDeclaredStaticFields, numInstanceFields, srcFileName, classLoaderSpec);
        this.classInfos.put(classID, classInfo);
        return classInfo;
    }

    @Override
    public synchronized void clearClasses(int ... classIDs) {
        int[] nArray = classIDs;
        int n = classIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.classInfos.remove(id);
            this.heapInfos.remove(id);
            ++n2;
        }
    }

    @Override
    public synchronized void clearAll() {
        this.objectInfos.clear();
        this.classInfos.clear();
        this.heapInfos.clear();
    }

    @Override
    public ITypeHeapInfo<IClassInfo> createTypeHeapInfo(IClassInfo classInfo, int numInstances, long size, float growthRate, long creationMillis) {
        ITypeHeapInfo<IClassInfo> heapInfo = super.createTypeHeapInfo(classInfo, numInstances, size, growthRate, creationMillis);
        this.heapInfos.put(classInfo.getClassId(), heapInfo);
        return heapInfo;
    }

    @Override
    public ITypeHeapInfo<IClassInfo> getLastTypeHeapInfo(IClassInfo classInfo) {
        return this.heapInfos.get(classInfo.getClassId());
    }

    @Override
    public void markDiscarded(IObjectInfo objectInfo) {
        if (this.getObjectInfo(objectInfo.getObjectId()) == objectInfo) {
            super.markDiscarded(objectInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassRef
    implements IClassRef {
        private int classID;

        public ClassRef(int classID) {
            this.classID = classID;
        }

        @Override
        public int getClassId() {
            return this.classID;
        }

        @Override
        public <T> T select(ITypeResolver<T> resolver) {
            return resolver.withClassID(this.classID);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof IClassRef && this.classID == ((IClassRef)other).getClassId();
        }

        public int hashCode() {
            return this.classID;
        }

        public String toString() {
            return "ClassRef[id=" + this.classID + ']';
        }
    }

    private static class ObjSpec
    implements IObjectSpecifier {
        private int objectID;

        public ObjSpec(int objectID) {
            this.objectID = objectID;
        }

        public int getObjectId() {
            return this.objectID;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof IObjectSpecifier && this.objectID == ((IObjectSpecifier)other).getObjectId();
        }

        public int hashCode() {
            return this.objectID;
        }

        public String toString() {
            return "ObjectSpec[id=" + this.objectID + ']';
        }
    }
}

