/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.ConnectionClosedException;
import com.jrockit.memleak.mlp.MlpErr;
import com.jrockit.memleak.mlp.MlpUtil;
import com.jrockit.memleak.mlp.RequestType;
import com.jrockit.memleak.mlp.ServerRequest;
import com.jrockit.memleak.mlp.ServerResponse;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

class CommunicationChannel {
    private static final int SHUTDOWN_TIMEOUT_MILLIS = 1000;
    private LinkedList<ServerRequest> sendQ = new LinkedList();
    private LinkedList<ServerResponse> recvQ = new LinkedList();
    private ArrayList<Integer> cancelledIds = new ArrayList();
    private SendThread sender;
    private ReceiveThread receiver;
    private Socket sock;
    private volatile IOException disconnectCause;
    private boolean m_requestShutDown;

    CommunicationChannel(String host, int port) throws IOException {
        this.sock = new Socket(host, port);
        this.sender = new SendThread(this.sock);
        this.sender.start();
        this.receiver = new ReceiveThread(this.sock);
        this.receiver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postResponse(ServerResponse sr) {
        LinkedList<ServerResponse> linkedList = this.recvQ;
        synchronized (linkedList) {
            this.recvQ.addLast(sr);
            this.recvQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(ServerRequest sr) {
        LinkedList<ServerRequest> linkedList = this.sendQ;
        synchronized (linkedList) {
            this.sendQ.addLast(sr);
            this.sendQ.notifyAll();
        }
    }

    ServerResponse postRequestAndWait(ServerRequest req) throws IOException {
        this.postRequest(req);
        return this.waitForReply(req.getId());
    }

    private ServerResponse waitForReply(int id, boolean waitForAsync, long maxWaitTime) throws IOException {
        LinkedList<ServerResponse> linkedList = this.recvQ;
        synchronized (linkedList) {
            long timeLeft = maxWaitTime;
            while (true) {
                long start = System.currentTimeMillis();
                if (this.disconnectCause != null) {
                    throw new ConnectionClosedException(this.disconnectCause);
                }
                Iterator iter = this.recvQ.iterator();
                while (iter.hasNext()) {
                    ServerResponse resp = (ServerResponse)iter.next();
                    if (this.cancelledIds.contains(new Integer(resp.getId()))) {
                        System.err.println("Got reply for cancelled request " + resp.getId());
                        this.cancelledIds.remove(new Integer(resp.getId()));
                        iter.remove();
                    }
                    if (resp.getId() == id) {
                        iter.remove();
                        return resp;
                    }
                    if (!waitForAsync || !resp.isAsync()) continue;
                    iter.remove();
                    return resp;
                }
                try {
                    this.recvQ.wait(maxWaitTime);
                    long waited = System.currentTimeMillis() - start;
                    if (maxWaitTime <= 0L || (timeLeft -= waited) >= 0L) continue;
                    this.cancelledIds.add(new Integer(id));
                    throw new IOException("Timed out waiting for reply");
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    ServerResponse waitForAsyncReply() throws IOException {
        return this.waitForReply(0, true, 0L);
    }

    ServerResponse waitForReply(int id) throws IOException {
        return this.waitForReply(id, false, 0L);
    }

    ServerResponse waitForReply(int id, int timeoutMillis) throws IOException {
        return this.waitForReply(id, false, timeoutMillis);
    }

    private void serverDisconnect(IOException ex) {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.disconnectWithException(ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sendQ.clear();
        this.recvQ.clear();
    }

    private synchronized boolean keepRunning() {
        return !this.m_requestShutDown;
    }

    private synchronized void requestShutDown() {
        this.m_requestShutDown = true;
    }

    void disconnect() throws IOException {
        this.disconnectWithException(new ConnectionClosedException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectWithException(IOException ex) throws IOException {
        LinkedList<ServerResponse> linkedList = this.recvQ;
        synchronized (linkedList) {
            this.disconnectCause = ex;
            this.recvQ.notifyAll();
        }
        this.requestShutDown();
        try {
            try {
                this.sender.close();
                this.sender.join(1000L);
                this.receiver.join(1000L);
            }
            catch (InterruptedException e) {
                MlpUtil.log(e);
                this.receiver.close();
                this.sock.close();
            }
        }
        finally {
            this.sock.close();
        }
    }

    boolean isConnected() {
        return this.sock.isConnected() && !this.sock.isClosed();
    }

    long getBytesRead() {
        return this.receiver.getBytesRead();
    }

    class ReceiveThread
    extends Thread {
        private Socket receiveSocket;
        private DataInputStream in;
        private long bytesRead;

        ReceiveThread(Socket sock) throws UnknownHostException, IOException {
            this.receiveSocket = sock;
            this.in = new DataInputStream(this.receiveSocket.getInputStream());
            this.setName("MemLeak Server Receive Thread");
            this.setDaemon(true);
        }

        public void run() {
            while (CommunicationChannel.this.keepRunning()) {
                this.readResponse();
            }
        }

        private void readResponse() {
            block5: {
                try {
                    RequestType type = RequestType.get(this.in.readInt());
                    MlpErr errCode = MlpErr.get(this.in.readInt());
                    int flags = this.in.readInt();
                    int id = this.in.readInt();
                    int length = this.in.readInt();
                    this.bytesRead += 20L;
                    byte[] data = new byte[length];
                    this.in.readFully(data);
                    this.bytesRead += (long)length;
                    ServerResponse resp = new ServerResponse(type, errCode, flags, id, data);
                    CommunicationChannel.this.postResponse(resp);
                }
                catch (IOException ex) {
                    if (!ReceiveThread.interrupted()) {
                        CommunicationChannel.this.serverDisconnect(ex);
                    }
                    CommunicationChannel.this.requestShutDown();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) break block5;
                    throw new RuntimeException(e);
                }
            }
            if (ReceiveThread.interrupted()) {
                CommunicationChannel.this.requestShutDown();
            }
        }

        void close() throws IOException {
            CommunicationChannel.this.requestShutDown();
            this.in.close();
            this.interrupt();
        }

        long getBytesRead() {
            return this.bytesRead;
        }
    }

    class SendThread
    extends Thread {
        private Socket sendSocket;
        private DataOutputStream out;

        SendThread(Socket socket) throws UnknownHostException, IOException {
            this.sendSocket = socket;
            this.out = new DataOutputStream(this.sendSocket.getOutputStream());
            this.setName("MemLeak Server Send Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LinkedList linkedList = CommunicationChannel.this.sendQ;
                synchronized (linkedList) {
                    while (CommunicationChannel.this.keepRunning()) {
                        if (!this.sendQueuedData()) {
                            return;
                        }
                        CommunicationChannel.this.sendQ.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.sendSocket.isClosed() && !this.sendSocket.isOutputShutdown()) {
                try {
                    this.sendRequest(new ServerRequest(RequestType.REQ_DISCONNECT));
                    this.sendSocket.shutdownOutput();
                }
                catch (IOException e) {
                    MlpUtil.log(e);
                }
            }
        }

        private boolean sendQueuedData() {
            while (!CommunicationChannel.this.sendQ.isEmpty()) {
                ServerRequest req = (ServerRequest)CommunicationChannel.this.sendQ.removeFirst();
                try {
                    this.sendRequest(req);
                }
                catch (IOException ex) {
                    CommunicationChannel.this.serverDisconnect(ex);
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendRequest(ServerRequest req) throws IOException {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                byte[] data = req.getRequestData();
                this.out.writeInt(req.getType().ordinal());
                this.out.writeInt(req.getId());
                this.out.writeInt(data.length);
                if (data.length > 0) {
                    this.out.write(data);
                }
            }
        }

        void close() throws IOException {
            CommunicationChannel.this.requestShutDown();
            this.interrupt();
        }
    }
}

