/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.mlp;

import com.jrockit.memleak.AllocTraceCallback;
import com.jrockit.memleak.ConnectionClosedException;
import com.jrockit.memleak.DisconnectCallback;
import com.jrockit.memleak.Feature;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IFieldValue;
import com.jrockit.memleak.IHeapHistogram;
import com.jrockit.memleak.IMemLeak;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IMethodInfo;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.IPointToTypeInfo;
import com.jrockit.memleak.ITrace;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.ITypeHeapInfo;
import com.jrockit.memleak.ITypeResolver;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NoSuchIdException;
import com.jrockit.memleak.TrendAnalysisCallback;
import com.jrockit.memleak.mlp.CommunicationChannel;
import com.jrockit.memleak.mlp.InfoCachingFactory;
import com.jrockit.memleak.mlp.JoinedTypeHeapInfo;
import com.jrockit.memleak.mlp.MemLeakR26;
import com.jrockit.memleak.mlp.MemLeakR28;
import com.jrockit.memleak.mlp.MlpErr;
import com.jrockit.memleak.mlp.MlpUtil;
import com.jrockit.memleak.mlp.RequestType;
import com.jrockit.memleak.mlp.ServerRequest;
import com.jrockit.memleak.mlp.ServerResponse;
import com.jrockit.memleak.util.IInfoCacheControl;
import com.jrockit.memleak.util.MemLeakAdapter;
import com.jrockit.memleak.util.Present;
import com.jrockit.memleak.value.ClassInfo;
import com.jrockit.memleak.value.KnownTruncatable;
import com.jrockit.memleak.value.ObjectInfo;
import com.jrockit.memleak.value.TypeHeapInfo;
import com.jrockit.memleak.value.ValueFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemLeak
extends MemLeakAdapter {
    public static final String META_SUPPORTED_MLP_REQUESTS = "SUPPORTED_MLP_REQUESTS";
    public static final String META_MLP_REQUEST_REVISIONS = "MLP_REQUEST_REVISIONS";
    public static final IClassInfo INVALID_CLASS_INFO = new ClassInfo(-1, null, 0, -1, -1, null, null);
    public static final IObjectInfo INVALID_OBJECT_INFO = new ObjectInfo(-1, INVALID_CLASS_INFO);
    protected IMemleakValueFactory factory;
    protected IInfoCacheControl infoCache;
    protected ITypeResolver<IClassInfo> classInfoResolver;
    protected AsyncCallbackThread callbackThread;
    protected final CommunicationChannel channel;
    protected double histogramCutoff = 0.001;
    private Map<String, ITypeHeapInfo<?>> lastHeapInfoMap;
    protected EnumSet<RequestType> enabledRequests;
    protected long numIgnoredBytes;
    protected Set<Feature> features;

    public static IMemLeak createMemLeak(String host, int port) throws IOException {
        DataInputStream dis;
        CommunicationChannel channel = new CommunicationChannel(host, port);
        ServerRequest req = new ServerRequest(RequestType.REQ_IS_TREND_ENABLED);
        ServerResponse resp = channel.postRequestAndWait(req);
        try {
            dis = resp.createDataInputStream();
        }
        catch (MemLeakServerException mlse) {
            channel.disconnect();
            IOException ioe = new IOException(mlse.getMessage());
            ioe.initCause(mlse);
            throw ioe;
        }
        dis.readBoolean();
        int major = 2;
        int minor = 0;
        if (dis.available() >= 4) {
            major = dis.readInt();
            if (dis.available() >= 4) {
                minor = dis.readInt();
            }
        }
        if (major == 2) {
            return new MemLeakR26(channel, port);
        }
        if (MemLeakR28.supportsMlpVersion(major, minor)) {
            return new MemLeakR28(channel, port);
        }
        throw new RuntimeException("This MemLeak Protocol version (" + major + '.' + minor + ") is not supported.");
    }

    protected AbstractMemLeak(CommunicationChannel channel, int port) {
        this.channel = channel;
        this.setFactory(null);
        this.metaData.put("SERVER_PORT", new Integer(port));
        this.metaData.put("READ_BYTES", new Integer(-17));
        this.metaData.put("IGNORED_REPLY_BYTES", new Integer(-17));
        this.callbackThread = new AsyncCallbackThread(channel);
        this.callbackThread.start();
    }

    protected EnumSet<RequestType> createSafeSupportedReqs() {
        EnumSet<RequestType> reqs = EnumSet.range(RequestType.REQ_HEAP_HISTOGRAM_R26, RequestType.REQ_FULL_GC);
        reqs.remove((Object)RequestType.REQ_ALLOC_TRACES_R26);
        reqs.remove((Object)RequestType.REQ_CONNECT);
        return reqs;
    }

    protected EnumSet<RequestType> getSupportedRequests() throws IOException {
        if (this.enabledRequests == null) {
            ServerRequest req = new ServerRequest(RequestType.REQ_GET_CAPABILITIES);
            ServerResponse resp = this.channel.postRequestAndWait(req);
            if (resp.isServerError()) {
                this.enabledRequests = this.createSafeSupportedReqs();
            } else {
                try {
                    DataInputStream in = resp.createDataInputStream();
                    this.enabledRequests = MlpUtil.readEnumSet(RequestType.class, in, in.readInt());
                }
                catch (MemLeakServerException e) {
                    this.enabledRequests = this.createSafeSupportedReqs();
                }
            }
        }
        return this.enabledRequests;
    }

    protected boolean supportsRequest(RequestType requestType) throws IOException {
        return this.getSupportedRequests().contains((Object)requestType);
    }

    protected void checkSupported(RequestType requestType) throws IOException, MemLeakServerException {
        if (!this.getSupportedRequests().contains((Object)requestType)) {
            throw new MemLeakServerException("Unsupported operation (according to server capabilities)");
        }
    }

    protected void reportIgnoredBytes(int numBytes) {
        this.numIgnoredBytes += (long)numBytes;
    }

    protected void reportUnusedBytes(DataInputStream dis) throws IOException {
        this.reportIgnoredBytes(dis.available());
    }

    @Override
    public void setFactory(IMemleakValueFactory factory) {
        factory = factory != null ? factory : ValueFactory.getDefault();
        this.factory = factory = factory instanceof IInfoCacheControl ? factory : new InfoCachingFactory(factory);
        this.infoCache = (IInfoCacheControl)((Object)factory);
    }

    @Override
    public Object getMetaData(Object key) {
        if ("READ_BYTES".equals(key)) {
            return new Long(this.channel != null ? this.channel.getBytesRead() : 0L);
        }
        if ("IGNORED_REPLY_BYTES".equals(key)) {
            return new Long(this.numIgnoredBytes);
        }
        if (META_SUPPORTED_MLP_REQUESTS.equals(key)) {
            try {
                return this.getSupportedRequests();
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.getMetaData(key);
    }

    @Override
    public Set<Feature> getFeatures() {
        if (this.features == null) {
            EnumSet<Feature> feats = EnumSet.noneOf(Feature.class);
            try {
                this.initFeatures(feats, this.getSupportedRequests());
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            this.features = Collections.unmodifiableSet(feats);
        }
        return this.features;
    }

    protected void initFeatures(EnumSet<Feature> features, EnumSet<RequestType> requests) {
        if (requests.contains((Object)RequestType.REQ_FULL_GC)) {
            features.add(Feature.GC_TRIGGER);
        }
    }

    protected boolean isJlcClass(IClassInfo clsInfo) {
        return clsInfo.getName().equals("java/lang/Class");
    }

    @Override
    public void setTrendAnalysisCallback(TrendAnalysisCallback cb) throws IOException {
        this.callbackThread.setTrendCallback(cb);
    }

    @Override
    public void setTrendAnalysisEnabled(boolean enabled) throws IOException, IllegalStateException, MemLeakServerException {
        if (enabled && this.callbackThread.getTrendCallback() == null) {
            throw new IllegalStateException("No callback has been registered");
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_SET_TREND_ENABLED);
        req.addArgument(enabled);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    @Override
    public boolean isTrendAnalysisEnabled() throws IOException, MemLeakServerException {
        if (!this.isConnected()) {
            return false;
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_IS_TREND_ENABLED);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream in = resp.createDataInputStream();
        try {
            boolean bl = in.readBoolean();
            return bl;
        }
        finally {
            this.reportUnusedBytes(in);
        }
    }

    @Override
    public IHeapHistogram getHeapHistogram() throws IOException, MemLeakServerException {
        ServerRequest req = this.createHeapHistogramReq();
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            IHeapHistogram iHeapHistogram = this.parseHeapUsage(dis, this.histogramCutoff);
            return iHeapHistogram;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    protected abstract ServerRequest createHeapHistogramReq();

    @Override
    public void setHistogramCutoff(double histogramCutoff) throws IllegalArgumentException {
        if (histogramCutoff < 0.0 || histogramCutoff > 1.0) {
            throw new IllegalArgumentException("The histogram cutoff must be between 0 and 1. It was being set to " + histogramCutoff + ".");
        }
        this.histogramCutoff = histogramCutoff;
    }

    @Override
    public double getHistogramCutoff() {
        return this.histogramCutoff;
    }

    @Override
    public IPointToTypeInfo[] getTypesPointingTo(ITypeSpecifier type, long oldestAcceptable) throws IOException, MemLeakServerException {
        ServerRequest req = this.createTypesPointingToReq(type);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream in = resp.createDataInputStream();
        try {
            IPointToTypeInfo info;
            ArrayList<IPointToTypeInfo> infos = new ArrayList<IPointToTypeInfo>();
            while ((info = this.parseTypesPointingTo(in)) != null) {
                infos.add(info);
            }
            IPointToTypeInfo[] iPointToTypeInfoArray = infos.toArray(IPointToTypeInfo.EMPTY_ARRAY);
            return iPointToTypeInfoArray;
        }
        finally {
            this.reportUnusedBytes(in);
        }
    }

    protected abstract ServerRequest createTypesPointingToReq(ITypeSpecifier var1) throws IOException, MemLeakServerException;

    @Override
    public int getArrayLength(IObjectSpecifier objectSpec) throws IOException, IllegalArgumentException, MemLeakServerException {
        this.checkSpecValidity(objectSpec);
        ServerRequest req = new ServerRequest(RequestType.REQ_ARRAY_LENGTH);
        req.addArgument(objectSpec);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream dis = resp.createDataInputStream();
        try {
            int n = dis.readInt();
            return n;
        }
        finally {
            this.reportUnusedBytes(dis);
        }
    }

    protected void checkSpecValidity(IObjectSpecifier objectSpec) throws NoSuchIdException {
        int objID = objectSpec.getObjectId();
        if (objID < 0) {
            throw new NoSuchIdException("The object specifier with ID=<" + objID + "> does not specify a valid object.");
        }
    }

    @Override
    public void enableAllocTracesForClass(ITypeSpecifier type, int bufferSize, int interval, AllocTraceCallback callback) throws IOException, IllegalStateException, MemLeakServerException {
        if (callback == null) {
            throw new NullPointerException("Null callback");
        }
        if (this.isAllocTracesEnabled()) {
            throw new IllegalStateException("alloc traces are already enabled");
        }
        this.callbackThread.setAllocTraceCallback(callback);
        ServerRequest req = this.createEnableAllocTracesForClassReq(type, bufferSize, interval);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    protected abstract ServerRequest createEnableAllocTracesForClassReq(ITypeSpecifier var1, int var2, int var3) throws IOException, MemLeakServerException;

    @Override
    public void pollAllocationTraces() throws IOException, IllegalStateException, MemLeakServerException {
        if (this.callbackThread.getAllocTraceCallback() == null) {
            throw new IllegalStateException("No callback has been registered. Allocation traces are probably not enabled.");
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_POLL_ALLOC_TRACES);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        if (resp.getServerError() == MlpErr.OPERATION_FAILED) {
            throw new IllegalStateException(resp.getServerErrorMessage());
        }
        resp.throwAnyError();
    }

    @Override
    public boolean isAllocTracesEnabled() throws IOException, MemLeakServerException {
        if (!this.isConnected()) {
            return false;
        }
        ServerRequest req = new ServerRequest(RequestType.REQ_IS_ALLOC_TRACE_ENABLED);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream in = resp.createDataInputStream();
        try {
            boolean bl = in.readBoolean();
            return bl;
        }
        finally {
            this.reportUnusedBytes(in);
        }
    }

    @Override
    public void disableAllocTraces() throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_DISABLE_ALLOC_TRACE);
        this.channel.postRequestAndWait(req).throwAnyError();
        this.callbackThread.setAllocTraceCallback(null);
    }

    @Override
    public void setAllocTraceFrequency(int reportInterval) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_SET_ALLOC_TRACE_FREQ);
        req.addArgument(reportInterval);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    @Override
    public int getAllocTraceFrequency() throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_GET_ALLOC_TRACE_FREQ);
        ServerResponse resp = this.channel.postRequestAndWait(req);
        DataInputStream in = resp.createDataInputStream();
        try {
            int n = in.readInt();
            return n;
        }
        finally {
            this.reportUnusedBytes(in);
        }
    }

    @Override
    public void doFullGC() throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_FULL_GC);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    @Override
    public void deleteObjectId(int objectId) throws IOException, MemLeakServerException {
        ServerRequest req = new ServerRequest(RequestType.REQ_DELETE_OBJID_R26);
        req.addArgument(objectId);
        this.channel.postRequestAndWait(req).throwAnyError();
    }

    @Override
    public void deleteObjectIds(int ... objectIds) throws IOException, MemLeakServerException {
        ServerRequest[] reqs = new ServerRequest[objectIds.length];
        int i = 0;
        while (i < reqs.length) {
            reqs[i] = new ServerRequest(RequestType.REQ_DELETE_OBJID_R26);
            reqs[i].addArgument(objectIds[i]);
            this.channel.postRequest(reqs[i]);
            ++i;
        }
        ServerRequest[] serverRequestArray = reqs;
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            ServerRequest req = serverRequestArray[n2];
            this.channel.waitForReply(req.getId()).throwAnyError();
            ++n2;
        }
    }

    @Override
    public void destroy() throws IOException {
        this.callbackThread.setTrendCallback(null);
        this.callbackThread.setAllocTraceCallback(null);
        this.disconnect();
        this.callbackThread.setDisconnectCallback(null);
    }

    @Override
    public void setDisconnectCallback(DisconnectCallback disconnectCallback) {
        this.callbackThread.setDisconnectCallback(disconnectCallback);
    }

    private void disconnect() throws IOException {
        this.channel.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    protected IPointToTypeInfo parseTypesPointingTo(DataInputStream dis) throws IOException, MemLeakServerException {
        if (dis.available() == 0) {
            return null;
        }
        IClassInfo referredClass = this.parseClass(dis);
        if (referredClass == INVALID_CLASS_INFO) {
            return null;
        }
        int referredTypeInstances = dis.readInt();
        int totalRef = dis.readInt();
        int n = dis.readInt();
        int[] instances = new int[n];
        IClassInfo[] referrerClasses = new IClassInfo[n];
        int i = 0;
        while (i < n) {
            referrerClasses[i] = this.parseClass(dis);
            instances[i] = dis.readInt();
            ++i;
        }
        return this.factory.createPointToTypeInfo(referredClass, referredTypeInstances, instances, referrerClasses, totalRef);
    }

    @Override
    public ITypeHeapInfo<IClassInfo> getLastTypeHeapInfo(IClassInfo classInfo, long oldestAcceptable) {
        return this.infoCache.getLastTypeHeapInfo(classInfo);
    }

    @Override
    public ITypeHeapInfo<?> getLastTypeHeapInfo(String refType, long oldestAcceptable) {
        return this.lastHeapInfoMap != null ? this.lastHeapInfoMap.get(refType) : null;
    }

    protected IHeapHistogram parseHeapUsage(DataInputStream dis, double histogramCutoff) throws IOException, MemLeakServerException {
        if (dis.available() == 0) {
            return null;
        }
        long totalSize = dis.readLong();
        int n = dis.readInt();
        long time = System.currentTimeMillis();
        ArrayList<ITypeHeapInfo<IClassInfo>> infos = new ArrayList<ITypeHeapInfo<IClassInfo>>(n);
        HashMap typeMap = new HashMap(n);
        int totalNumInstances = 0;
        float totalGrowthRate = 0.0f;
        int i = 0;
        while (i < n) {
            IClassInfo ci = this.parseClass(dis);
            String refType = ci.getName();
            int numInstances = dis.readInt();
            totalNumInstances += numInstances;
            long size = dis.readLong();
            float growthRate = dis.readFloat();
            totalGrowthRate += growthRate;
            ITypeHeapInfo<IClassInfo> newInfo = this.factory.createTypeHeapInfo(ci, numInstances, size, growthRate, time);
            ITypeHeapInfo storedInfo = (ITypeHeapInfo)typeMap.get(refType);
            if (storedInfo == null) {
                typeMap.put(refType, newInfo);
            } else if (storedInfo instanceof JoinedTypeHeapInfo) {
                ((JoinedTypeHeapInfo)storedInfo).add(newInfo);
            } else if (storedInfo instanceof TypeHeapInfo) {
                JoinedTypeHeapInfo joinedInfo = new JoinedTypeHeapInfo(refType, time);
                joinedInfo.add((TypeHeapInfo)storedInfo);
                joinedInfo.add(newInfo);
                typeMap.put(refType, joinedInfo);
            }
            double ratio = (double)size / (double)totalSize;
            if (ratio >= histogramCutoff) {
                infos.add(newInfo);
            }
            ++i;
        }
        this.lastHeapInfoMap = typeMap;
        return this.factory.createHeapHistogram(totalNumInstances, totalSize, totalGrowthRate, time, infos, typeMap.values());
    }

    protected abstract IFieldValue[] parseFieldValues(DataInputStream var1, boolean var2) throws IOException, MemLeakServerException;

    protected abstract IMethodInfo parseMethodInfo(DataInputStream var1) throws IOException, MemLeakServerException;

    protected Object readPrimitive(DataInputStream dis, char type) throws IOException {
        switch (type) {
            case 'Z': {
                return dis.readBoolean();
            }
            case 'B': {
                return dis.readByte();
            }
            case 'C': {
                return Character.valueOf(dis.readChar());
            }
            case 'S': {
                return dis.readShort();
            }
            case 'I': {
                return dis.readInt();
            }
            case 'J': {
                return dis.readLong();
            }
            case 'F': {
                return new Float(dis.readFloat());
            }
            case 'D': {
                return new Double(dis.readDouble());
            }
        }
        throw new IllegalArgumentException("Type '" + type + "' is not a known primitive type");
    }

    protected abstract ITrace[] parseAllocTraces(DataInputStream var1) throws IOException, MemLeakServerException;

    protected abstract IObjectInfo parseObject(DataInputStream var1) throws IOException, MemLeakServerException;

    protected abstract IObjectSpecifier parseObject(DataInputStream var1, IClassInfo var2, boolean var3) throws IOException, MemLeakServerException;

    protected abstract IClassInfo parseClass(DataInputStream var1) throws IOException, MemLeakServerException;

    protected class AsyncCallbackThread
    extends Thread {
        private CommunicationChannel commChannel;
        private AllocTraceCallback allocTraceCallback;
        private TrendAnalysisCallback trendCallback;
        private DisconnectCallback disconnectCallback;

        public AsyncCallbackThread(CommunicationChannel commChannel) {
            this.commChannel = commChannel;
            this.setName("MemLeak Async Callback Thread");
            this.setDaemon(true);
        }

        public synchronized void setAllocTraceCallback(AllocTraceCallback atc) {
            this.allocTraceCallback = atc;
        }

        public synchronized AllocTraceCallback getAllocTraceCallback() {
            return this.allocTraceCallback;
        }

        public synchronized void setTrendCallback(TrendAnalysisCallback tac) {
            this.trendCallback = tac;
        }

        public synchronized TrendAnalysisCallback getTrendCallback() {
            return this.trendCallback;
        }

        public synchronized void setDisconnectCallback(DisconnectCallback disconnectCallback) {
            this.disconnectCallback = disconnectCallback;
        }

        public DisconnectCallback getDisconnectCallback() {
            return this.disconnectCallback;
        }

        public void run() {
            try {
                while (true) {
                    ServerResponse resp = this.commChannel.waitForAsyncReply();
                    this.doResponse(resp);
                }
            }
            catch (ConnectionClosedException cce) {
                if (!cce.isIntentionallyClosed()) {
                    this.doDisconnect(cce);
                }
            }
            catch (Exception ex) {
                this.doDisconnect(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doResponse(ServerResponse resp) {
            try {
                switch (resp.getType()) {
                    case REQ_HEAP_HISTOGRAM_R26: 
                    case REQ_HEAP_HISTOGRAM_R28: {
                        AsyncCallbackThread asyncCallbackThread = this;
                        synchronized (asyncCallbackThread) {
                            if (this.trendCallback != null) {
                                IHeapHistogram hh = AbstractMemLeak.this.parseHeapUsage(resp.createDataInputStream(), AbstractMemLeak.this.histogramCutoff);
                                this.trendCallback.receiveHeapHistogram(hh);
                            } else {
                                System.err.println("No TrendAnalysisCallback registered");
                            }
                            break;
                        }
                    }
                    case REQ_ALLOC_TRACES_R26: 
                    case REQ_ALLOC_TRACES_R28: {
                        AsyncCallbackThread asyncCallbackThread = this;
                        synchronized (asyncCallbackThread) {
                            if (this.allocTraceCallback != null) {
                                ITrace[] traces = AbstractMemLeak.this.parseAllocTraces(resp.createDataInputStream());
                                this.allocTraceCallback.receiveAllocTraces(traces);
                            } else {
                                System.err.println("No AllocTraceCallback registered");
                            }
                            break;
                        }
                    }
                    default: {
                        System.err.println("Unknown asynchronous respsonse of type: " + (Object)((Object)resp.getType()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                MlpUtil.logger().log(Level.WARNING, "Exception while processing asynchronous callback for type: " + (Object)((Object)resp.getType()), e);
            }
        }

        private synchronized void doDisconnect(Exception ex) {
            if (this.disconnectCallback != null) {
                this.disconnectCallback.disconnectEvent(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class DelayedTruncatable<T>
    implements ITruncatable<T> {
        protected ServerRequest req;
        private int reqID = -1;
        private T[] result;
        private Object reason;

        public DelayedTruncatable(RequestType reqType) {
            this.req = new ServerRequest(reqType);
        }

        public DelayedTruncatable<T> send() {
            if (this.reqID != -1) {
                throw new IllegalStateException("Request already sent");
            }
            this.reqID = this.req.getId();
            AbstractMemLeak.this.channel.postRequest(this.req);
            return this;
        }

        public ITruncatable<T> sendIfSupported() {
            try {
                if (AbstractMemLeak.this.supportsRequest(this.req.getType())) {
                    return this.send();
                }
            }
            catch (IOException e) {
                MlpUtil.log(e);
                return new KnownTruncatable<T>(this.getEmptyResult(), e);
            }
            return new KnownTruncatable<T>(this.getEmptyResult(), ITruncatable.Reason.UNSUPPORTED);
        }

        protected T[] getEmptyResult() {
            return this.req.getType().emptyArray();
        }

        @Override
        public T[] get() {
            if (this.reqID == -1) {
                this.send();
            }
            if (this.result == null) {
                block11: {
                    try {
                        ServerResponse resp = AbstractMemLeak.this.channel.waitForReply(this.reqID);
                        DataInputStream dis = resp.createDataInputStream();
                        this.reason = resp.getFlagsAsReason();
                        if (dis.available() == 0) {
                            if (this.reason == null) {
                                this.reason = ITruncatable.Reason.EMPTY_REPLY;
                            }
                            break block11;
                        }
                        try {
                            this.result = this.parseResponse(dis);
                        }
                        finally {
                            AbstractMemLeak.this.reportUnusedBytes(dis);
                        }
                    }
                    catch (IOException e) {
                        this.reason = e;
                    }
                    catch (MemLeakServerException e) {
                        this.reason = e;
                    }
                }
                if (this.result == null) {
                    this.result = this.getEmptyResult();
                }
            }
            return this.result;
        }

        protected abstract T[] parseResponse(DataInputStream var1) throws IOException, MemLeakServerException;

        @Override
        public boolean isTruncated() {
            this.get();
            return this.reason != null;
        }

        @Override
        public Object getTruncationReason() {
            this.get();
            return this.reason;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ReqProcessor<T>
    implements Future<T> {
        protected ServerRequest req;
        private int reqID = -1;
        private T result;

        public ReqProcessor(RequestType reqType) {
            this.req = new ServerRequest(reqType);
        }

        public ReqProcessor<T> send() {
            if (this.reqID != -1) {
                throw new IllegalStateException("Request already sent");
            }
            this.reqID = this.req.getId();
            AbstractMemLeak.this.channel.postRequest(this.req);
            return this;
        }

        public Future<T> sendIfSupported() {
            try {
                if (AbstractMemLeak.this.supportsRequest(this.req.getType())) {
                    return this.send();
                }
            }
            catch (IOException e) {
                MlpUtil.log(e);
            }
            return new Present<Object>(null);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public T get() throws ExecutionException {
            if (this.reqID == -1) {
                this.send();
            }
            if (this.result == null) {
                try {
                    ServerResponse resp = AbstractMemLeak.this.channel.waitForReply(this.reqID);
                    DataInputStream dis = resp.createDataInputStream();
                    try {
                        this.result = this.parseResponse(dis);
                    }
                    finally {
                        AbstractMemLeak.this.reportUnusedBytes(dis);
                    }
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
                catch (MemLeakServerException e) {
                    throw new ExecutionException(e);
                }
            }
            return this.result;
        }

        protected abstract T parseResponse(DataInputStream var1) throws IOException, MemLeakServerException;

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }
    }
}

