/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.comm;

import com.jrockit.memleak.IMemLeak;
import com.jrockit.memleak.MemLeakFactory;
import com.jrockit.memleak.comm.Controller;
import com.jrockit.memleak.comm.MemLeakControllerException;
import com.jrockit.memleak.mlp.MlpUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMLSController {
    private static Map<String, ProtocolDescriptor> DESCRIPTOR_BY_ID = new HashMap<String, ProtocolDescriptor>();
    private static List<ProtocolDescriptor> DESCRIPTORS = new ArrayList<ProtocolDescriptor>();

    static {
        RemoteMLSController.addProtocol("RJMX", "RJMX (JDK 5.0 and above)", 7091, "com.jrockit.memleak.comm.ControllerRJMX");
        RemoteMLSController.addProtocol("RMP", "RMP (JDK 1.4)", 7090, "com.jrockit.memleak.comm.ControllerRMP");
        RemoteMLSController.addProtocol("MLS", "Memleak (server already running)", 7095, "com.jrockit.memleak.comm.ControllerDummy");
    }

    private static void addProtocol(String id, String description, int port, String className) {
        ProtocolDescriptor descriptor = new ProtocolDescriptor(id, description, port, className);
        DESCRIPTOR_BY_ID.put(id.toLowerCase(), descriptor);
        DESCRIPTORS.add(descriptor);
    }

    public static void main(String[] args) {
        if (args.length < 3 || args.length > 5) {
            System.out.println("Usage:");
            System.out.println("\t" + RemoteMLSController.class.getName() + " <command> <hostName> <port> <username> <password>");
            System.out.println("\nUsername and password is optional. Command is [start|stop|port|versions]");
            return;
        }
        String command = args[0];
        String hostName = args[1];
        String userName = null;
        String password = null;
        int port = Integer.parseInt(args[2]);
        if (args.length > 3) {
            userName = args[3];
            if (args.length > 4) {
                password = args[4];
            }
        }
        try {
            Controller starter = RemoteMLSController.getController(null, hostName, port, userName, password);
            if (command.equals("start")) {
                System.out.println("Attempting to start MLS...");
                System.out.println("MLS started on port " + starter.startMLS() + ".");
            } else if (command.equals("stop")) {
                System.out.println("Attempting to shut down MLS...");
                starter.shutDownMLS();
                System.out.println("Shut down command sent.");
            } else if (command.equals("port")) {
                System.out.println("Retrieving port no...");
                int portNo = starter.getMLSPort();
                if (portNo == 0) {
                    System.out.println("MLS not started.");
                } else {
                    System.out.println("MLS port is " + portNo + ".");
                }
            } else if (command.equals("versions")) {
                starter.printAvailableProtocolVersions();
            } else {
                System.out.println("Unknown command: " + command);
            }
        }
        catch (IOException e) {
            MlpUtil.log(e);
        }
    }

    public static ProtocolDescriptor getDescriptor(String protocol) {
        return protocol != null ? DESCRIPTOR_BY_ID.get(protocol.toLowerCase()) : null;
    }

    public static String getDefaultProtocol() {
        ProtocolDescriptor descriptor = RemoteMLSController.getAvailableDescriptor(null);
        return descriptor != null ? descriptor.getID() : null;
    }

    public static ProtocolDescriptor getAvailableDescriptor(String preferredProtocol) {
        ProtocolDescriptor descriptor = RemoteMLSController.getDescriptor(preferredProtocol);
        if (descriptor != null && descriptor.isAvailable()) {
            return descriptor;
        }
        Iterator<ProtocolDescriptor> descriptors = RemoteMLSController.getAllDescriptors();
        while (descriptors.hasNext()) {
            descriptor = descriptors.next();
            if (!descriptor.isAvailable()) continue;
            return descriptor;
        }
        return null;
    }

    public static Iterator<ProtocolDescriptor> getAllDescriptors() {
        return DESCRIPTORS.iterator();
    }

    public static Controller getController(String protocol, String serverName, int port, String username, String password) throws MemLeakControllerException {
        ProtocolDescriptor descriptor2 = RemoteMLSController.getDescriptor(protocol);
        Controller controller = RemoteMLSController.tryController(descriptor2, serverName, port, username, password);
        if (controller != null) {
            return controller;
        }
        for (ProtocolDescriptor descriptor2 : DESCRIPTORS) {
            controller = RemoteMLSController.tryController(descriptor2, serverName, port, username, password);
            if (controller == null) continue;
            return controller;
        }
        throw new MemLeakControllerException("Could not connect using protocol " + protocol + " or fallback protocols on " + (port != 0 ? "port " + port + '.' : "default ports."));
    }

    private static Controller tryController(ProtocolDescriptor descriptor, String serverName, int port, String username, String password) {
        if (descriptor != null && descriptor.isAvailable()) {
            try {
                String className = descriptor.getClassName();
                Class<?> type = Class.forName(className);
                Constructor<?> constructor = type.getConstructor(Controller.CONSTRUCTOR_SIGNATURE);
                Controller controller = (Controller)constructor.newInstance(serverName, new Integer(port), username, password);
                return controller;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return null;
    }

    public static IMemLeak connectTo(String serverName, int port, String username, String password, int preferredMLSPort) throws IOException {
        Controller controller = RemoteMLSController.getController(null, serverName, port, username, password);
        int mlsPort = controller.startMLS(preferredMLSPort);
        if (preferredMLSPort != 0 && mlsPort != preferredMLSPort) {
            System.out.println("Warning - could not start mlsserver at " + preferredMLSPort + ". Communication started at " + mlsPort + " instead.");
        }
        return MemLeakFactory.createMemLeak(serverName, mlsPort);
    }

    public static class ProtocolDescriptor {
        private String id;
        private String description;
        private int defaultPort;
        private String className;
        private boolean tested;
        private boolean available;

        private ProtocolDescriptor(String id, String description, int defaultPort, String className) {
            this.id = id;
            this.description = description;
            this.defaultPort = defaultPort;
            this.className = className;
        }

        public boolean isAvailable() {
            if (!this.tested) {
                try {
                    Class.forName(this.className);
                    this.available = true;
                }
                catch (ClassNotFoundException cnfe) {
                    this.available = false;
                }
                catch (LinkageError le) {
                    this.available = false;
                }
                this.tested = true;
            }
            return this.available;
        }

        public String getID() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.isAvailable() ? this.description : String.valueOf(this.description) + " <unavailable>";
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        private String getClassName() {
            return this.className;
        }
    }
}

